/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import javax.servlet.ServletContext;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.AutomagicMadvocConfigurator;
import jodd.madvoc.MadvocException;
import jodd.madvoc.WebApp;
import jodd.props.Props;
import jodd.props.PropsUtil;
import jodd.typeconverter.Converter;
import jodd.util.ClassLoaderUtil;
import jodd.util.ClassUtil;

public class Madvoc {
    public static final String PARAM_MADVOC_WEBAPP = "madvoc.webapp";
    public static final String PARAM_MADVOC_CONFIGURATOR = "madvoc.configurator";
    public static final String PARAM_MADVOC_PARAMS = "madvoc.params";
    private static Logger log;
    private static final String MADVOC_ATTR;
    protected String webAppClassName;
    protected Class webAppClass = WebApp.class;
    protected String[] paramsFiles;
    protected String madvocConfiguratorClassName;
    protected Class madvocConfiguratorClass = AutomagicMadvocConfigurator.class;
    protected WebApp webapp;
    protected ServletContext servletContext;

    public static Madvoc get(ServletContext servletContext) {
        return (Madvoc)servletContext.getAttribute(MADVOC_ATTR);
    }

    public void setWebAppClassName(String webAppClass) {
        this.webAppClassName = webAppClass;
        this.webAppClass = null;
    }

    public void setWebAppClass(Class webAppClass) {
        this.webAppClass = webAppClass;
        this.webAppClassName = null;
    }

    public void setMadvocConfiguratorClassName(String madvocConfiguratorClassName) {
        this.madvocConfiguratorClassName = madvocConfiguratorClassName;
        this.madvocConfiguratorClass = null;
    }

    public void setMadvocConfiguratorClass(Class madvocConfiguratorClass) {
        this.madvocConfiguratorClass = madvocConfiguratorClass;
        this.madvocConfiguratorClassName = null;
    }

    public void setParamsFiles(String[] paramsFiles) {
        this.paramsFiles = paramsFiles;
    }

    public void configureWith(ServletContext servletContext) {
        this.webAppClassName = servletContext.getInitParameter(PARAM_MADVOC_WEBAPP);
        this.paramsFiles = Converter.get().toStringArray(servletContext.getInitParameter(PARAM_MADVOC_PARAMS));
        this.madvocConfiguratorClassName = servletContext.getInitParameter(PARAM_MADVOC_CONFIGURATOR);
    }

    public WebApp webapp() {
        return this.webapp;
    }

    public WebApp startWebApplication(ServletContext servletContext) {
        try {
            WebApp webApp = this._start(servletContext);
            log.info("Madvoc is up and running.");
            return webApp;
        }
        catch (Exception ex) {
            if (log != null) {
                log.error("Madvoc startup failure.", (Throwable)ex);
            } else {
                ex.printStackTrace();
            }
            if (ex instanceof MadvocException) {
                throw (MadvocException)ex;
            }
            throw new MadvocException(ex);
        }
    }

    private WebApp _start(ServletContext servletContext) {
        if (servletContext != null) {
            this.servletContext = servletContext;
            servletContext.setAttribute(MADVOC_ATTR, (Object)this);
        }
        this.webapp = this.createWebApplication();
        log = LoggerFactory.getLogger(Madvoc.class);
        this.webapp.bindServletContext(servletContext);
        if (this.paramsFiles != null) {
            Props params = this.loadMadvocParams(this.paramsFiles);
            this.webapp.withParams(params);
        }
        this.resolveMadvocConfigClass();
        if (this.madvocConfiguratorClass != null) {
            this.webapp.registerComponent(this.madvocConfiguratorClass);
        }
        log.info("Madvoc starting...");
        this.webapp.start();
        return this.webapp;
    }

    public void stopWebApplication() {
        log.info("Madvoc shutting down...");
        if (this.servletContext != null) {
            this.servletContext.removeAttribute(MADVOC_ATTR);
        }
        this.webapp.shutdown();
        this.webapp = null;
    }

    protected WebApp createWebApplication() {
        WebApp webApp;
        if (this.webAppClassName == null && this.webAppClass == null) {
            return new WebApp();
        }
        try {
            if (this.webAppClassName != null) {
                this.webAppClass = ClassLoaderUtil.loadClass(this.webAppClassName);
            }
            webApp = (WebApp)ClassUtil.newInstance(this.webAppClass);
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to load Madvoc web application class: " + this.webAppClassName, ex);
        }
        return webApp;
    }

    protected Props loadMadvocParams(String[] patterns) {
        if (log.isInfoEnabled()) {
            log.info("Loading Madvoc parameters from: " + Converter.get().toString(patterns));
        }
        try {
            return PropsUtil.createFromClasspath(patterns);
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to load Madvoc parameters from: " + Converter.get().toString(patterns) + ".properties': " + ex.toString(), ex);
        }
    }

    protected void resolveMadvocConfigClass() {
        if (this.madvocConfiguratorClassName == null && this.madvocConfiguratorClass == null) {
            return;
        }
        try {
            if (this.madvocConfiguratorClassName != null) {
                this.madvocConfiguratorClass = ClassLoaderUtil.loadClass(this.madvocConfiguratorClassName);
            }
            log.info("Configuring Madvoc using: " + this.madvocConfiguratorClass.getName());
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to load Madvoc configurator class: " + this.madvocConfiguratorClassName, ex);
        }
    }

    static {
        MADVOC_ATTR = Madvoc.class.getName();
    }
}

