/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import jodd.exception.ExceptionUtil;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;

public class AsyncActionExecutor {
    private static final Logger log = LoggerFactory.getLogger(AsyncActionExecutor.class);
    protected ExecutorService executorService;
    private int corePoolSize = 10;
    private int maximumPoolSize = 200;
    private long keepAliveTimeMillis = 5000L;
    private int queueCapacity = 100;

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setKeepAliveTimeMillis(long keepAliveTimeMillis) {
        this.keepAliveTimeMillis = keepAliveTimeMillis;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void start() {
        this.executorService = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTimeMillis, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.queueCapacity));
    }

    public void invoke(ActionRequest actionRequest) {
        if (this.executorService == null) {
            throw new MadvocException("No action is marked as async!");
        }
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        log.debug(() -> "Async call to: " + actionRequest);
        AsyncContext asyncContext = servletRequest.startAsync();
        this.executorService.submit(() -> {
            try {
                actionRequest.invoke();
            }
            catch (Exception ex) {
                log.error("Invoking async action path failed: ", ExceptionUtil.unwrapThrowable(ex));
            }
            finally {
                asyncContext.complete();
            }
        });
    }
}

