/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jodd.bean.BeanUtil;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeType;
import jodd.madvoc.injector.ContextInjector;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Targets;
import jodd.servlet.CsrfShield;
import jodd.servlet.ServletUtil;
import jodd.servlet.map.HttpServletContextMap;
import jodd.servlet.map.HttpServletRequestMap;
import jodd.servlet.map.HttpServletRequestParamMap;
import jodd.servlet.map.HttpSessionMap;
import jodd.util.StringUtil;

public class ServletContextScopeInjector
implements Injector,
ContextInjector<ServletContext> {
    private static final ScopeType SCOPE_TYPE = ScopeType.SERVLET;
    public static final String REQUEST_NAME = "request";
    public static final String SESSION_NAME = "session";
    public static final String CONTEXT_NAME = "context";
    public static final String REQUEST_MAP = "requestMap";
    public static final String REQUEST_PARAM_MAP = "requestParamMap";
    public static final String REQUEST_BODY = "requestBody";
    public static final String SESSION_MAP = "sessionMap";
    public static final String CONTEXT_MAP = "contextMap";
    public static final String CSRF_NAME = "csrfTokenValid";

    @Override
    public void inject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
            Class fieldType = in.type;
            Object value = null;
            if (fieldType.equals(HttpServletRequest.class)) {
                value = servletRequest;
            } else if (fieldType.equals(ServletRequest.class)) {
                value = servletRequest;
            } else if (fieldType.equals(HttpServletResponse.class)) {
                value = servletResponse;
            } else if (fieldType.equals(ServletResponse.class)) {
                value = servletResponse;
            } else if (fieldType.equals(HttpSession.class)) {
                value = servletRequest.getSession();
            } else if (fieldType.equals(ServletContext.class)) {
                value = servletRequest.getSession().getServletContext();
            } else if (in.name.equals(REQUEST_MAP)) {
                value = new HttpServletRequestMap(servletRequest);
            } else if (in.name.equals(REQUEST_PARAM_MAP)) {
                value = new HttpServletRequestParamMap(servletRequest);
            } else if (in.name.equals(REQUEST_BODY)) {
                try {
                    value = ServletUtil.readRequestBody(servletRequest);
                }
                catch (IOException e) {
                    value = e.toString();
                }
            } else if (in.name.equals(REQUEST_BODY)) {
                value = new HttpServletRequestParamMap(servletRequest);
            } else if (in.name.equals(SESSION_MAP)) {
                value = new HttpSessionMap(servletRequest);
            } else if (in.name.equals(CONTEXT_MAP)) {
                value = new HttpServletContextMap(servletRequest);
            } else if (in.name.startsWith(REQUEST_NAME)) {
                String name = StringUtil.uncapitalize(in.name.substring(REQUEST_NAME.length()));
                if (!name.isEmpty()) {
                    value = BeanUtil.declared.getProperty(servletRequest, name);
                }
            } else if (in.name.startsWith(SESSION_NAME)) {
                String name = StringUtil.uncapitalize(in.name.substring(SESSION_NAME.length()));
                if (!name.isEmpty()) {
                    value = BeanUtil.declared.getProperty(servletRequest.getSession(), name);
                }
            } else if (in.name.startsWith(CONTEXT_NAME)) {
                String name = StringUtil.uncapitalize(in.name.substring(CONTEXT_NAME.length()));
                if (!name.isEmpty()) {
                    value = BeanUtil.declared.getProperty(servletRequest.getSession().getServletContext(), name);
                }
            } else if (in.name.equals(CSRF_NAME)) {
                value = CsrfShield.checkCsrfToken(servletRequest);
            }
            if (value != null) {
                target.writeValue(in.propertyName(), value, true);
            }
        });
    }

    @Override
    public void injectContext(Targets targets, ServletContext servletContext) {
        targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
            Class fieldType = in.type;
            Object value = null;
            if (fieldType.equals(ServletContext.class)) {
                value = servletContext;
            } else if (in.name.equals(CONTEXT_MAP)) {
                value = new HttpServletContextMap(servletContext);
            } else if (in.name.startsWith(CONTEXT_NAME)) {
                value = BeanUtil.declared.getProperty(servletContext, StringUtil.uncapitalize(in.name.substring(CONTEXT_NAME.length())));
            }
            if (value != null) {
                target.writeValue(in.propertyName(), value, true);
            }
        });
    }
}

