/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.lang.reflect.Constructor;
import jodd.bean.BeanUtil;
import jodd.madvoc.MadvocException;
import jodd.madvoc.config.ScopeData;
import jodd.typeconverter.TypeConverterManager;

public class Target {
    protected final Class type;
    protected Object value;

    public Target(Object value) {
        this.value = value;
        this.type = null;
    }

    public Target(Object value, Class type) {
        this.value = value;
        this.type = type;
    }

    public Target(Class type) {
        this.type = type;
        this.value = null;
    }

    public Class getType() {
        return this.type;
    }

    public Class resolveType() {
        if (this.type != null) {
            return this.type;
        }
        return this.value.getClass();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object readValue(String propertyName) {
        if (this.type != null) {
            int dotNdx = propertyName.indexOf(46);
            if (dotNdx == -1) {
                return this.value;
            }
            propertyName = propertyName.substring(dotNdx + 1);
        }
        return BeanUtil.declared.getProperty(this.value, propertyName);
    }

    public Object readTargetProperty(ScopeData.Out out) {
        if (out.target == null) {
            return this.readValue(out.name);
        }
        return this.readValue(out.target);
    }

    public void writeValue(String propertyName, Object propertyValue, boolean silent) {
        if (this.type != null) {
            int dotNdx = propertyName.indexOf(46);
            if (dotNdx == -1) {
                this.value = TypeConverterManager.get().convertType(propertyValue, this.type);
                return;
            }
            if (this.value == null) {
                this.createValueInstance();
            }
            propertyName = propertyName.substring(dotNdx + 1);
        }
        if (silent) {
            BeanUtil.declaredForcedSilent.setProperty(this.value, propertyName, propertyValue);
            return;
        }
        BeanUtil.declaredForced.setProperty(this.value, propertyName, propertyValue);
    }

    protected void createValueInstance() {
        try {
            Constructor ctor = this.type.getDeclaredConstructor(null);
            ctor.setAccessible(true);
            this.value = ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
    }
}

