/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import jodd.mail.MailException;

abstract class MailSession<T extends Service>
implements AutoCloseable {
    private final Session session;
    protected final Service service;

    protected MailSession(Session session, Service service) {
        this.session = session;
        this.service = service;
    }

    public void open() {
        try {
            this.service.connect();
        }
        catch (MessagingException msex) {
            throw new MailException("Open session error", msex);
        }
    }

    @Override
    public void close() {
        try {
            this.service.close();
        }
        catch (MessagingException mex) {
            throw new MailException("Failed to close session", mex);
        }
    }

    public boolean isConnected() {
        return this.service.isConnected();
    }

    public Session getSession() {
        return this.session;
    }

    public abstract T getService();
}

