/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.lang.reflect.Method;
import jodd.asm.AsmUtil;
import jodd.asm6.Label;
import jodd.asm6.MethodVisitor;
import jodd.asm6.Type;
import jodd.proxetta.JoddProxetta;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.TypeInfo;
import jodd.util.ClassUtil;
import jodd.util.StringBand;

public class ProxettaAsmUtil {
    public static final String INIT = "<init>";
    public static final String CLINIT = "<clinit>";
    public static final String DESC_VOID = "()V";

    public static void pushInt(MethodVisitor mv, int value) {
        if (value <= 5) {
            mv.visitInsn(3 + value);
        } else if (value <= 127) {
            mv.visitIntInsn(16, value);
        } else {
            mv.visitIntInsn(17, value);
        }
    }

    public static int makePrivateFinalAccess(int access) {
        return access & 0xFFFFFFF0 | 2 | 0x10;
    }

    public static void checkArgumentIndex(MethodInfo methodInfo, int argIndex) {
        if (argIndex < 1 || argIndex > methodInfo.getArgumentsCount()) {
            throw new ProxettaException("Invalid argument index: " + argIndex);
        }
    }

    public static String adviceFieldName(String name, int index) {
        return JoddProxetta.get().defaults().getFieldPrefix() + name + JoddProxetta.get().defaults().getFieldDivider() + index;
    }

    public static String adviceMethodName(String name, int index) {
        return JoddProxetta.get().defaults().getMethodPrefix() + name + JoddProxetta.get().defaults().getMethodDivider() + index;
    }

    public static void loadMethodArgumentClass(MethodVisitor mv, MethodInfo methodInfo, int index) {
        TypeInfo argument = methodInfo.getArgument(index);
        ProxettaAsmUtil.loadClass(mv, argument.getOpcode(), argument.getRawName());
    }

    public static void loadClass(MethodVisitor mv, int type, String typeName) {
        switch (type) {
            case 86: {
                mv.visitFieldInsn(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 66: {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 67: {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 83: {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 73: {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 90: {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 74: {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 70: {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 68: {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                break;
            }
            default: {
                mv.visitLdcInsn(Type.getType(typeName));
            }
        }
    }

    public static void loadSpecialMethodArguments(MethodVisitor mv, MethodInfo methodInfo) {
        mv.visitVarInsn(25, 0);
        for (int i = 1; i <= methodInfo.getArgumentsCount(); ++i) {
            ProxettaAsmUtil.loadMethodArgument(mv, methodInfo, i);
        }
    }

    public static void loadStaticMethodArguments(MethodVisitor mv, MethodInfo methodInfo) {
        for (int i = 0; i < methodInfo.getArgumentsCount(); ++i) {
            ProxettaAsmUtil.loadMethodArgument(mv, methodInfo, i);
        }
    }

    public static void loadVirtualMethodArguments(MethodVisitor mv, MethodInfo methodInfo) {
        for (int i = 1; i <= methodInfo.getArgumentsCount(); ++i) {
            ProxettaAsmUtil.loadMethodArgument(mv, methodInfo, i);
        }
    }

    public static void loadMethodArgument(MethodVisitor mv, MethodInfo methodInfo, int index) {
        int offset = methodInfo.getArgumentOffset(index);
        char type = methodInfo.getArgument(index).getOpcode();
        switch (type) {
            case 'V': {
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                mv.visitVarInsn(21, offset);
                break;
            }
            case 'J': {
                mv.visitVarInsn(22, offset);
                break;
            }
            case 'F': {
                mv.visitVarInsn(23, offset);
                break;
            }
            case 'D': {
                mv.visitVarInsn(24, offset);
                break;
            }
            default: {
                mv.visitVarInsn(25, offset);
            }
        }
    }

    public static void loadMethodArgumentAsObject(MethodVisitor mv, MethodInfo methodInfo, int index) {
        int offset = methodInfo.getArgumentOffset(index);
        char type = methodInfo.getArgument(index).getOpcode();
        switch (type) {
            case 'V': {
                break;
            }
            case 'B': {
                mv.visitVarInsn(21, offset);
                AsmUtil.valueOfByte(mv);
                break;
            }
            case 'C': {
                mv.visitVarInsn(21, offset);
                AsmUtil.valueOfCharacter(mv);
                break;
            }
            case 'S': {
                mv.visitVarInsn(21, offset);
                AsmUtil.valueOfShort(mv);
                break;
            }
            case 'I': {
                mv.visitVarInsn(21, offset);
                AsmUtil.valueOfInteger(mv);
                break;
            }
            case 'Z': {
                mv.visitVarInsn(21, offset);
                AsmUtil.valueOfBoolean(mv);
                break;
            }
            case 'J': {
                mv.visitVarInsn(22, offset);
                AsmUtil.valueOfLong(mv);
                break;
            }
            case 'F': {
                mv.visitVarInsn(23, offset);
                AsmUtil.valueOfFloat(mv);
                break;
            }
            case 'D': {
                mv.visitVarInsn(24, offset);
                AsmUtil.valueOfDouble(mv);
                break;
            }
            default: {
                mv.visitVarInsn(25, offset);
            }
        }
    }

    public static void storeMethodArgument(MethodVisitor mv, MethodInfo methodInfo, int index) {
        int offset = methodInfo.getArgumentOffset(index);
        char type = methodInfo.getArgument(index).getOpcode();
        switch (type) {
            case 'V': {
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                mv.visitVarInsn(54, offset);
                break;
            }
            case 'J': {
                mv.visitVarInsn(55, offset);
                break;
            }
            case 'F': {
                mv.visitVarInsn(56, offset);
                break;
            }
            case 'D': {
                mv.visitVarInsn(57, offset);
                break;
            }
            default: {
                mv.visitVarInsn(58, offset);
            }
        }
    }

    public static boolean isStoreOpcode(int opcode) {
        return opcode == 54 || opcode == 55 || opcode == 56 || opcode == 57 || opcode == 58;
    }

    public static void storeMethodArgumentFromObject(MethodVisitor mv, MethodInfo methodInfo, int index) {
        char type = methodInfo.getArgument(index).getOpcode();
        int offset = methodInfo.getArgumentOffset(index);
        ProxettaAsmUtil.storeValue(mv, offset, type);
    }

    public static void storeValue(MethodVisitor mv, int offset, int type) {
        switch (type) {
            case 86: {
                break;
            }
            case 66: {
                AsmUtil.byteValue(mv);
                mv.visitVarInsn(54, offset);
                break;
            }
            case 67: {
                AsmUtil.charValue(mv);
                mv.visitVarInsn(54, offset);
                break;
            }
            case 83: {
                AsmUtil.shortValue(mv);
                mv.visitVarInsn(54, offset);
                break;
            }
            case 73: {
                AsmUtil.intValue(mv);
                mv.visitVarInsn(54, offset);
                break;
            }
            case 90: {
                AsmUtil.booleanValue(mv);
                mv.visitVarInsn(54, offset);
                break;
            }
            case 74: {
                AsmUtil.longValue(mv);
                mv.visitVarInsn(55, offset);
                break;
            }
            case 70: {
                AsmUtil.floatValue(mv);
                mv.visitVarInsn(56, offset);
                break;
            }
            case 68: {
                AsmUtil.doubleValue(mv);
                mv.visitVarInsn(57, offset);
                break;
            }
            default: {
                mv.visitVarInsn(58, offset);
            }
        }
    }

    public static void visitReturn(MethodVisitor mv, MethodInfo methodInfo, boolean isLast) {
        switch (methodInfo.getReturnType().getOpcode()) {
            case 'V': {
                if (isLast) {
                    mv.visitInsn(87);
                }
                mv.visitInsn(177);
                break;
            }
            case 'B': {
                if (isLast) {
                    mv.visitInsn(89);
                    Label label = new Label();
                    mv.visitJumpInsn(199, label);
                    mv.visitInsn(87);
                    mv.visitInsn(3);
                    mv.visitInsn(172);
                    mv.visitLabel(label);
                    AsmUtil.byteValue(mv);
                }
                mv.visitInsn(172);
                break;
            }
            case 'C': {
                if (isLast) {
                    mv.visitInsn(89);
                    Label label = new Label();
                    mv.visitJumpInsn(199, label);
                    mv.visitInsn(87);
                    mv.visitInsn(3);
                    mv.visitInsn(172);
                    mv.visitLabel(label);
                    AsmUtil.charValue(mv);
                }
                mv.visitInsn(172);
                break;
            }
            case 'S': {
                if (isLast) {
                    mv.visitInsn(89);
                    Label label = new Label();
                    mv.visitJumpInsn(199, label);
                    mv.visitInsn(87);
                    mv.visitInsn(3);
                    mv.visitInsn(172);
                    mv.visitLabel(label);
                    AsmUtil.shortValue(mv);
                }
                mv.visitInsn(172);
                break;
            }
            case 'I': {
                if (isLast) {
                    mv.visitInsn(89);
                    Label label = new Label();
                    mv.visitJumpInsn(199, label);
                    mv.visitInsn(87);
                    mv.visitInsn(3);
                    mv.visitInsn(172);
                    mv.visitLabel(label);
                    AsmUtil.intValue(mv);
                }
                mv.visitInsn(172);
                break;
            }
            case 'Z': {
                if (isLast) {
                    mv.visitInsn(89);
                    Label label = new Label();
                    mv.visitJumpInsn(199, label);
                    mv.visitInsn(87);
                    mv.visitInsn(3);
                    mv.visitInsn(172);
                    mv.visitLabel(label);
                    AsmUtil.booleanValue(mv);
                }
                mv.visitInsn(172);
                break;
            }
            case 'J': {
                if (isLast) {
                    mv.visitInsn(89);
                    Label label = new Label();
                    mv.visitJumpInsn(199, label);
                    mv.visitInsn(87);
                    mv.visitInsn(9);
                    mv.visitInsn(173);
                    mv.visitLabel(label);
                    AsmUtil.longValue(mv);
                }
                mv.visitInsn(173);
                break;
            }
            case 'F': {
                if (isLast) {
                    mv.visitInsn(89);
                    Label label = new Label();
                    mv.visitJumpInsn(199, label);
                    mv.visitInsn(87);
                    mv.visitInsn(11);
                    mv.visitInsn(174);
                    mv.visitLabel(label);
                    AsmUtil.floatValue(mv);
                }
                mv.visitInsn(174);
                break;
            }
            case 'D': {
                if (isLast) {
                    mv.visitInsn(89);
                    Label label = new Label();
                    mv.visitJumpInsn(199, label);
                    mv.visitInsn(87);
                    mv.visitInsn(14);
                    mv.visitInsn(175);
                    mv.visitLabel(label);
                    AsmUtil.doubleValue(mv);
                }
                mv.visitInsn(175);
                break;
            }
            default: {
                mv.visitInsn(176);
            }
        }
    }

    public static void prepareReturnValue(MethodVisitor mv, MethodInfo methodInfo, int varOffset) {
        varOffset += methodInfo.getAllArgumentsSize();
        switch (methodInfo.getReturnType().getOpcode()) {
            case 'V': {
                mv.visitInsn(1);
                break;
            }
            case 'B': {
                AsmUtil.valueOfByte(mv);
                break;
            }
            case 'C': {
                AsmUtil.valueOfCharacter(mv);
                break;
            }
            case 'S': {
                AsmUtil.valueOfShort(mv);
                break;
            }
            case 'I': {
                AsmUtil.valueOfInteger(mv);
                break;
            }
            case 'Z': {
                AsmUtil.valueOfBoolean(mv);
                break;
            }
            case 'J': {
                AsmUtil.valueOfLong(mv);
                break;
            }
            case 'F': {
                AsmUtil.valueOfFloat(mv);
                break;
            }
            case 'D': {
                AsmUtil.valueOfDouble(mv);
            }
        }
    }

    public static void castToReturnType(MethodVisitor mv, MethodInfo methodInfo) {
        String returnType;
        char returnOpcodeType = methodInfo.getReturnType().getOpcode();
        switch (returnOpcodeType) {
            case 'I': {
                returnType = "java/lang/Integer";
                break;
            }
            case 'J': {
                returnType = "java/lang/Long";
                break;
            }
            case 'S': {
                returnType = "java/lang/Short";
                break;
            }
            case 'B': {
                returnType = "java/lang/Byte";
                break;
            }
            case 'Z': {
                returnType = "java/lang/Boolean";
                break;
            }
            case 'F': {
                returnType = "java/lang/Float";
                break;
            }
            case 'D': {
                returnType = "java/lang/Double";
                break;
            }
            case 'C': {
                returnType = "java/lang/Character";
                break;
            }
            case '[': {
                returnType = methodInfo.getReturnType().getRawName();
                break;
            }
            default: {
                String rtname = methodInfo.getReturnType().getRawName();
                returnType = rtname.length() == 0 ? AsmUtil.typeToSignature(methodInfo.getReturnType().getType()) : AsmUtil.typedesc2ClassName(rtname);
            }
        }
        mv.visitTypeInsn(192, returnType);
    }

    public static String createMethodSignaturesKey(int access, String methodName, String description, String className) {
        return new StringBand(7).append(access).append(":").append(description).append("_").append(className).append("#").append(methodName).toString();
    }

    public static void visitElementValue(MethodVisitor mv, Object elementValue, boolean boxPrimitives) {
        if (elementValue instanceof String) {
            mv.visitLdcInsn(elementValue);
            return;
        }
        if (elementValue instanceof Type) {
            mv.visitLdcInsn(elementValue);
            return;
        }
        if (elementValue instanceof Class) {
            mv.visitLdcInsn(Type.getType((Class)elementValue));
            return;
        }
        if (elementValue instanceof Integer) {
            mv.visitLdcInsn(elementValue);
            if (boxPrimitives) {
                AsmUtil.valueOfInteger(mv);
            }
            return;
        }
        if (elementValue instanceof Long) {
            mv.visitLdcInsn(elementValue);
            if (boxPrimitives) {
                AsmUtil.valueOfLong(mv);
            }
            return;
        }
        if (elementValue instanceof Short) {
            mv.visitLdcInsn(elementValue);
            if (boxPrimitives) {
                AsmUtil.valueOfShort(mv);
            }
            return;
        }
        if (elementValue instanceof Byte) {
            mv.visitLdcInsn(elementValue);
            if (boxPrimitives) {
                AsmUtil.valueOfByte(mv);
            }
            return;
        }
        if (elementValue instanceof Float) {
            mv.visitLdcInsn(elementValue);
            if (boxPrimitives) {
                AsmUtil.valueOfFloat(mv);
            }
            return;
        }
        if (elementValue instanceof Double) {
            mv.visitLdcInsn(elementValue);
            if (boxPrimitives) {
                AsmUtil.valueOfDouble(mv);
            }
            return;
        }
        if (elementValue instanceof Character) {
            mv.visitLdcInsn(elementValue);
            if (boxPrimitives) {
                AsmUtil.valueOfCharacter(mv);
            }
            return;
        }
        if (elementValue instanceof Boolean) {
            mv.visitLdcInsn(elementValue);
            if (boxPrimitives) {
                AsmUtil.valueOfBoolean(mv);
            }
            return;
        }
        Class<?> elementValueClass = elementValue.getClass();
        Class enumClass = ClassUtil.findEnum(elementValueClass);
        if (enumClass != null) {
            try {
                String typeRef = AsmUtil.typeToTyperef(enumClass);
                String typeSignature = AsmUtil.typeToSignature(enumClass);
                Method nameMethod = elementValue.getClass().getMethod("name", new Class[0]);
                String name = (String)nameMethod.invoke(elementValue, new Object[0]);
                mv.visitFieldInsn(178, typeSignature, name, typeRef);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ProxettaException("Unsupported annotation type: " + elementValue.getClass());
    }

    public static void newArray(MethodVisitor mv, Class componentType) {
        if (componentType == Integer.TYPE) {
            mv.visitIntInsn(188, 10);
            return;
        }
        if (componentType == Long.TYPE) {
            mv.visitIntInsn(188, 11);
            return;
        }
        if (componentType == Float.TYPE) {
            mv.visitIntInsn(188, 6);
            return;
        }
        if (componentType == Double.TYPE) {
            mv.visitIntInsn(188, 7);
            return;
        }
        if (componentType == Byte.TYPE) {
            mv.visitIntInsn(188, 8);
            return;
        }
        if (componentType == Short.TYPE) {
            mv.visitIntInsn(188, 9);
            return;
        }
        if (componentType == Boolean.TYPE) {
            mv.visitIntInsn(188, 4);
            return;
        }
        if (componentType == Character.TYPE) {
            mv.visitIntInsn(188, 5);
            return;
        }
        mv.visitTypeInsn(189, AsmUtil.typeToSignature(componentType));
    }

    public static void storeIntoArray(MethodVisitor mv, Class componentType) {
        if (componentType == Integer.TYPE) {
            mv.visitInsn(79);
            return;
        }
        if (componentType == Long.TYPE) {
            mv.visitInsn(80);
            return;
        }
        if (componentType == Float.TYPE) {
            mv.visitInsn(81);
            return;
        }
        if (componentType == Double.TYPE) {
            mv.visitInsn(82);
            return;
        }
        if (componentType == Byte.TYPE) {
            mv.visitInsn(84);
            return;
        }
        if (componentType == Short.TYPE) {
            mv.visitInsn(86);
            return;
        }
        if (componentType == Boolean.TYPE) {
            mv.visitInsn(84);
            return;
        }
        if (componentType == Character.TYPE) {
            mv.visitInsn(85);
            return;
        }
        mv.visitInsn(83);
    }

    public static boolean isInvokeMethod(String name, String desc) {
        return name.equals("invoke") && desc.equals("()Ljava/lang/Object;");
    }

    public static boolean isArgumentsCountMethod(String name, String desc) {
        return name.equals("argumentsCount") && desc.equals("()I");
    }

    public static boolean isArgumentTypeMethod(String name, String desc) {
        return name.equals("argumentType") && desc.equals("(I)Ljava/lang/Class;");
    }

    public static boolean isArgumentMethod(String name, String desc) {
        return name.equals("argument") && desc.equals("(I)Ljava/lang/Object;");
    }

    public static boolean isSetArgumentMethod(String name, String desc) {
        return name.equals("setArgument") && desc.equals("(Ljava/lang/Object;I)V");
    }

    public static boolean isCreateArgumentsArrayMethod(String name, String desc) {
        return name.equals("createArgumentsArray") && desc.equals("()[Ljava/lang/Object;");
    }

    public static boolean isCreateArgumentsClassArrayMethod(String name, String desc) {
        return name.equals("createArgumentsClassArray") && desc.equals("()[Ljava/lang/Class;");
    }

    public static boolean isReturnTypeMethod(String name, String desc) {
        return name.equals("returnType") && desc.equals("()Ljava/lang/Class;");
    }

    public static boolean isTargetMethod(String name, String desc) {
        return name.equals("target") && desc.equals("()Ljava/lang/Object;");
    }

    public static boolean isTargetClassMethod(String name, String desc) {
        return name.equals("targetClass") && desc.equals("()Ljava/lang/Class;");
    }

    public static boolean isTargetMethodNameMethod(String name, String desc) {
        return name.equals("targetMethodName") && desc.equals("()Ljava/lang/String;");
    }

    public static boolean isTargetMethodSignatureMethod(String name, String desc) {
        return name.equals("targetMethodSignature") && desc.equals("()Ljava/lang/String;");
    }

    public static boolean isTargetMethodDescriptionMethod(String name, String desc) {
        return name.equals("targetMethodDescription") && desc.equals("()Ljava/lang/String;");
    }

    public static boolean isReturnValueMethod(String name, String desc) {
        return name.equals("returnValue") && desc.equals("(Ljava/lang/Object;)Ljava/lang/Object;");
    }

    public static boolean isInfoMethod(String name, String desc) {
        return name.equals("info") && desc.equals("()Ljodd/proxetta/ProxyTargetInfo;");
    }

    public static boolean isTargetMethodAnnotationMethod(String name, String desc) {
        return name.equals("targetMethodAnnotation") && desc.equals("(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
    }

    public static boolean isTargetClassAnnotationMethod(String name, String desc) {
        return name.equals("targetClassAnnotation") && desc.equals("(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
    }
}

