/*
 * Decompiled with CFR 0.152.
 */
package jodd.upload.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jodd.core.JoddCore;
import jodd.io.FastByteArrayOutputStream;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.upload.FileUpload;
import jodd.upload.MultipartRequestInputStream;

public class AdaptiveFileUpload
extends FileUpload {
    protected static final String TMP_FILE_SUFFIX = ".upload.tmp";
    protected final int memoryThreshold;
    protected final File uploadPath;
    protected final boolean breakOnError;
    protected final String[] fileExtensions;
    protected final boolean allowFileExtensions;
    protected File tempFile;
    protected byte[] data;

    AdaptiveFileUpload(MultipartRequestInputStream input, int memoryThreshold, File uploadPath, int maxFileSize, boolean breakOnError, String[] extensions, boolean allowed) {
        super(input, maxFileSize);
        this.memoryThreshold = memoryThreshold;
        this.uploadPath = uploadPath;
        this.breakOnError = breakOnError;
        this.fileExtensions = extensions;
        this.allowFileExtensions = allowed;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public File getUploadPath() {
        return this.uploadPath;
    }

    public boolean isBreakOnError() {
        return this.breakOnError;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public boolean isAllowFileExtensions() {
        return this.allowFileExtensions;
    }

    @Override
    public boolean isInMemory() {
        return this.data != null;
    }

    protected boolean matchFileExtension() throws IOException {
        String fileNameExtension = FileNameUtil.getExtension(this.getHeader().getFileName());
        for (String fileExtension : this.fileExtensions) {
            if (!fileNameExtension.equalsIgnoreCase(fileExtension)) continue;
            if (!this.allowFileExtensions) {
                if (this.breakOnError) {
                    throw new IOException("Upload filename extension not allowed: " + fileNameExtension);
                }
                this.size = this.input.skipToBoundary();
                return false;
            }
            return true;
        }
        if (this.allowFileExtensions) {
            if (this.breakOnError) {
                throw new IOException("Upload filename extension not allowed: " + fileNameExtension);
            }
            this.size = this.input.skipToBoundary();
            return false;
        }
        return true;
    }

    protected boolean checkUpload() throws IOException {
        return this.fileExtensions == null || this.matchFileExtension();
    }

    @Override
    protected void processStream() throws IOException {
        if (!this.checkUpload()) {
            return;
        }
        this.size = 0;
        if (this.memoryThreshold > 0) {
            FastByteArrayOutputStream fbaos = new FastByteArrayOutputStream(this.memoryThreshold + 1);
            int written = this.input.copyMax(fbaos, this.memoryThreshold + 1);
            this.data = fbaos.toByteArray();
            if (written <= this.memoryThreshold) {
                this.size = this.data.length;
                this.valid = true;
                return;
            }
        }
        this.tempFile = FileUtil.createTempFile(JoddCore.get().defaults().getTempFilePrefix(), TMP_FILE_SUFFIX, this.uploadPath);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        if (this.data != null) {
            this.size = this.data.length;
            out.write(this.data);
            this.data = null;
        }
        boolean deleteTempFile = false;
        try {
            if (this.maxFileSize == -1) {
                this.size += this.input.copyAll(out);
            } else {
                this.size += this.input.copyMax(out, this.maxFileSize - this.size + 1);
                if (this.size > this.maxFileSize) {
                    deleteTempFile = true;
                    this.fileTooBig = true;
                    this.valid = false;
                    if (this.breakOnError) {
                        throw new IOException("File upload (" + this.header.getFileName() + ") too big, > " + this.maxFileSize);
                    }
                    this.input.skipToBoundary();
                    return;
                }
            }
            this.valid = true;
        }
        finally {
            StreamUtil.close(out);
            if (deleteTempFile) {
                this.tempFile.delete();
                this.tempFile = null;
            }
        }
    }

    public void delete() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (this.data != null) {
            this.data = null;
        }
    }

    public File write(String destination) throws IOException {
        return this.write(new File(destination));
    }

    public File write(File destination) throws IOException {
        if (destination.isDirectory()) {
            destination = new File(destination, this.header.getFileName());
        }
        if (this.data != null) {
            FileUtil.writeBytes(destination, this.data);
        } else if (this.tempFile != null) {
            FileUtil.move(this.tempFile, destination);
        }
        return destination;
    }

    @Override
    public byte[] getFileContent() throws IOException {
        if (this.data != null) {
            return this.data;
        }
        if (this.tempFile != null) {
            return FileUtil.readBytes(this.tempFile);
        }
        return null;
    }

    @Override
    public InputStream getFileInputStream() throws IOException {
        if (this.data != null) {
            return new BufferedInputStream(new ByteArrayInputStream(this.data));
        }
        if (this.tempFile != null) {
            return new BufferedInputStream(new FileInputStream(this.tempFile));
        }
        return null;
    }
}

