/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.util.ClassLoaderUtil;
import jodd.util.ClassUtil;
import jodd.vtor.Check;
import jodd.vtor.Constraint;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.VtorException;

public class ValidationContext {
    private static final String ANN_SEVERITY = "severity";
    private static final String ANN_PROFILES = "profiles";
    private static final String ANN_MESSAGE = "message";
    protected final Map<String, List<Check>> map = new HashMap<String, List<Check>>();
    private static Map<Class, List<Check>> cache = new HashMap<Class, List<Check>>();

    public void add(Check check) {
        String name = check.getName();
        List<Check> list = this.map.get(name);
        if (list == null) {
            list = new ArrayList<Check>();
            this.map.put(name, list);
        }
        list.add(check);
    }

    public void addAll(List<Check> checkList) {
        for (Check check : checkList) {
            this.add(check);
        }
    }

    public static ValidationContext resolveFor(Class<?> target) {
        ValidationContext vc = new ValidationContext();
        vc.addClassChecks(target);
        return vc;
    }

    public void addClassChecks(Class target) {
        List<Check> list = cache.get(target);
        if (list == null) {
            PropertyDescriptor[] allProperties;
            list = new ArrayList<Check>();
            ClassDescriptor cd = ClassIntrospector.get().lookup(target);
            for (PropertyDescriptor propertyDescriptor : allProperties = cd.getAllPropertyDescriptors()) {
                this.collectPropertyAnnotationChecks(list, propertyDescriptor);
            }
            cache.put(target, list);
        }
        this.addAll(list);
    }

    protected void collectPropertyAnnotationChecks(List<Check> annChecks, PropertyDescriptor propertyDescriptor) {
        Annotation[] annotations;
        MethodDescriptor md;
        FieldDescriptor fd = propertyDescriptor.getFieldDescriptor();
        if (fd != null) {
            Annotation[] annotations2 = fd.getField().getAnnotations();
            this.collectAnnotationChecks(annChecks, propertyDescriptor.getType(), propertyDescriptor.getName(), annotations2);
        }
        if ((md = propertyDescriptor.getReadMethodDescriptor()) != null) {
            annotations = md.getMethod().getAnnotations();
            this.collectAnnotationChecks(annChecks, propertyDescriptor.getType(), propertyDescriptor.getName(), annotations);
        }
        if ((md = propertyDescriptor.getWriteMethodDescriptor()) != null) {
            annotations = md.getMethod().getAnnotations();
            this.collectAnnotationChecks(annChecks, propertyDescriptor.getType(), propertyDescriptor.getName(), annotations);
        }
    }

    protected void collectAnnotationChecks(List<Check> annChecks, Class targetType, String targetName, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            ValidationConstraint vc;
            Class constraintClass;
            block6: {
                Constraint c = annotation.annotationType().getAnnotation(Constraint.class);
                if (c == null) {
                    String constraintClassName = annotation.annotationType().getName() + "Constraint";
                    try {
                        constraintClass = ClassLoaderUtil.loadClass(constraintClassName, this.getClass().getClassLoader());
                        break block6;
                    }
                    catch (ClassNotFoundException ingore) {
                        continue;
                    }
                }
                constraintClass = c.value();
            }
            try {
                vc = this.newConstraint(constraintClass, targetType);
            }
            catch (Exception ex) {
                throw new VtorException("Invalid constraint: " + constraintClass.getClass().getName(), ex);
            }
            vc.configure(annotation);
            Check check = new Check(targetName, vc);
            this.copyDefaultCheckProperties(check, annotation);
            annChecks.add(check);
        }
    }

    protected <V extends ValidationConstraint> V newConstraint(Class<V> constraint, Class targetType) throws Exception {
        try {
            Constructor<V> ctor = constraint.getConstructor(new Class[0]);
            return (V)((ValidationConstraint)ctor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException ignore) {
            Constructor<V> ctor = constraint.getConstructor(ValidationContext.class);
            return (V)((ValidationConstraint)ctor.newInstance(ValidationContext.resolveFor(targetType)));
        }
    }

    protected void copyDefaultCheckProperties(Check destCheck, Annotation annotation) {
        Integer severity = (Integer)ClassUtil.readAnnotationValue(annotation, ANN_SEVERITY);
        destCheck.setSeverity(severity);
        String[] profiles = (String[])ClassUtil.readAnnotationValue(annotation, ANN_PROFILES);
        destCheck.setProfiles(profiles);
        String message = (String)ClassUtil.readAnnotationValue(annotation, ANN_MESSAGE);
        destCheck.setMessage(message);
    }

    protected void clearCache() {
        cache.clear();
    }
}

