/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import jodd.db.DbSqlException;
import jodd.db.connection.ConnectionProvider;
import jodd.db.oom.DbEntityManager;
import jodd.db.servers.Db2DbServer;
import jodd.db.servers.DbServer;
import jodd.db.servers.DerbyDbServer;
import jodd.db.servers.GenericDbServer;
import jodd.db.servers.HsqlDbServer;
import jodd.db.servers.InformixDbServer;
import jodd.db.servers.MySqlDbServer;
import jodd.db.servers.OracleDbServer;
import jodd.db.servers.PostgreSqlDbServer;
import jodd.db.servers.SQLiteDbServer;
import jodd.db.servers.SqlServerDbServer;
import jodd.db.servers.SybaseDbServer;
import jodd.log.Logger;
import jodd.log.LoggerFactory;

public class DbDetector {
    private static final Logger log = LoggerFactory.getLogger(DbDetector.class);

    public static DbServer detectDatabaseAndConfigureDbOom(ConnectionProvider cp) {
        cp.init();
        Connection connection = cp.getConnection();
        DbServer dbServer = DbDetector.detectDatabase(connection);
        cp.closeConnection(connection);
        dbServer.accept(DbEntityManager.get());
        return dbServer;
    }

    public static DbServer detectDatabase(Connection connection) {
        String version;
        int dbMajorVersion;
        String dbName;
        try {
            log.info("Detecting database...");
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            dbName = databaseMetaData.getDatabaseProductName();
            dbMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            int dbMinorVersion = databaseMetaData.getDatabaseMinorVersion();
            version = dbMajorVersion + "." + dbMinorVersion;
            log.info("Database: " + dbName + " v" + dbMajorVersion + "." + dbMinorVersion);
        }
        catch (SQLException sex) {
            String msg = sex.getMessage();
            if (msg.contains("explicitly set for database: DB2")) {
                return new Db2DbServer();
            }
            throw new DbSqlException(sex);
        }
        if (dbName.equals("Apache Derby")) {
            return new DerbyDbServer(version);
        }
        if (dbName.startsWith("DB2/")) {
            return new Db2DbServer(version);
        }
        if (dbName.equals("HSQL Database Engine")) {
            return new HsqlDbServer(version);
        }
        if (dbName.equals("Informix Dynamic Server")) {
            return new InformixDbServer(version);
        }
        if (dbName.startsWith("Microsoft SQL Server")) {
            return new SqlServerDbServer(version);
        }
        if (dbName.equals("MySQL")) {
            return new MySqlDbServer(version);
        }
        if (dbName.equals("Oracle")) {
            return new OracleDbServer(version);
        }
        if (dbName.equals("PostgreSQL")) {
            return new PostgreSqlDbServer(version);
        }
        if (dbName.equals("Sybase SQL Server")) {
            return new SybaseDbServer(version);
        }
        if (dbName.equals("ASE") && dbMajorVersion == 15) {
            return new SybaseDbServer(version);
        }
        if (dbName.equals("SQLite")) {
            return new SQLiteDbServer(version);
        }
        return new GenericDbServer();
    }
}

