/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.MethodDescriptor;
import jodd.io.findfile.ClassScanner;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.MadvocComponentLifecycle;
import jodd.madvoc.component.MadvocContainer;
import jodd.madvoc.meta.ActionAnnotation;
import jodd.madvoc.meta.MadvocAction;
import jodd.madvoc.meta.MadvocComponent;
import jodd.petite.meta.PetiteInject;

public class AutomagicMadvocConfigurator
implements MadvocComponentLifecycle.Init,
MadvocComponentLifecycle.Start {
    private static final Logger log = LoggerFactory.getLogger(AutomagicMadvocConfigurator.class);
    private final ClassScanner classScanner = new ClassScanner();
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected MadvocContainer madvocContainer;
    protected String actionClassSuffix = "Action";
    protected long elapsed;
    protected final byte[] madvocComponentAnnotation;
    protected List<Runnable> webappConfigurations = new ArrayList<Runnable>();
    protected List<Runnable> madvocComponents = new ArrayList<Runnable>();
    private Consumer<ClassScanner.EntryData> ENTRY_CONSUMER = new Consumer<ClassScanner.EntryData>(){

        @Override
        public void accept(ClassScanner.EntryData entryData) {
            String entryName = entryData.name();
            if (entryName.endsWith(AutomagicMadvocConfigurator.this.actionClassSuffix)) {
                try {
                    AutomagicMadvocConfigurator.this.onActionClass(entryName);
                }
                catch (Exception ex) {
                    log.debug("Invalid Madvoc action, ignoring: " + entryName);
                }
            } else if (entryData.isTypeSignatureInUse(AutomagicMadvocConfigurator.this.madvocComponentAnnotation)) {
                try {
                    AutomagicMadvocConfigurator.this.onMadvocComponentClass(entryName);
                }
                catch (Exception ex) {
                    log.debug("Invalid Madvoc component ignoring: {}" + entryName);
                }
            }
        }
    };

    public AutomagicMadvocConfigurator() {
        this.madvocComponentAnnotation = ClassScanner.bytecodeSignatureOfType(MadvocComponent.class);
    }

    public AutomagicMadvocConfigurator withScanner(Consumer<ClassScanner> scannerConsumer) {
        scannerConsumer.accept(this.classScanner);
        return this;
    }

    @Override
    public void init() {
        this.elapsed = System.currentTimeMillis();
        this.classScanner.smartModeEntries();
        this.classScanner.onEntry(this.ENTRY_CONSUMER);
        this.classScanner.scanDefaultClasspath();
        try {
            this.classScanner.start();
        }
        catch (Exception ex) {
            throw new MadvocException("Scan classpath error", ex);
        }
        this.madvocComponents.forEach(Runnable::run);
        this.elapsed = System.currentTimeMillis() - this.elapsed;
    }

    @Override
    public void start() {
        long now = System.currentTimeMillis();
        this.webappConfigurations.forEach(Runnable::run);
        this.elapsed += System.currentTimeMillis() - now;
        log.info("Madvoc configured in " + this.elapsed + " ms. Total actions: " + this.actionsManager.getActionsCount());
    }

    public boolean checkClass(Class clazz) {
        try {
            if (clazz.isAnonymousClass()) {
                return false;
            }
            if (clazz.isArray() || clazz.isEnum()) {
                return false;
            }
            if (clazz.isInterface()) {
                return false;
            }
            if (clazz.isLocalClass()) {
                return false;
            }
            if (clazz.isMemberClass() ^ Modifier.isStatic(clazz.getModifiers())) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            int modifiers = clazz.getModifiers();
            return !Modifier.isAbstract(modifiers);
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    protected void onActionClass(String className) throws ClassNotFoundException {
        MethodDescriptor[] allMethodDescriptors;
        Class actionClass = this.classScanner.loadClass(className);
        if (actionClass == null) {
            return;
        }
        if (!this.checkClass(actionClass)) {
            return;
        }
        if (actionClass.getAnnotation(MadvocAction.class) == null) {
            return;
        }
        ClassDescriptor cd = ClassIntrospector.get().lookup(actionClass);
        for (MethodDescriptor methodDescriptor : allMethodDescriptors = cd.getAllMethodDescriptors()) {
            if (!methodDescriptor.isPublic()) continue;
            Method method = methodDescriptor.getMethod();
            boolean hasAnnotation = false;
            for (ActionAnnotation<?> actionAnnotation : this.madvocConfig.getActionAnnotationInstances()) {
                if (!actionAnnotation.hasAnnotationOn(method)) continue;
                hasAnnotation = true;
                break;
            }
            if (!hasAnnotation) continue;
            this.webappConfigurations.add(() -> this.actionsManager.registerAction(actionClass, method, null));
        }
    }

    protected void onMadvocComponentClass(String className) throws ClassNotFoundException {
        Class componentClass = this.classScanner.loadClass(className);
        if (componentClass == null) {
            return;
        }
        if (!this.checkClass(componentClass)) {
            return;
        }
        this.madvocComponents.add(() -> this.madvocContainer.registerComponent(componentClass));
    }
}

