/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeType;
import jodd.madvoc.config.ScopeData;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Outjector;
import jodd.madvoc.injector.Targets;

public class SessionScopeInjector
implements Injector,
Outjector {
    private static final ScopeType SCOPE_TYPE = ScopeType.SESSION;

    @Override
    public void inject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpSession session = servletRequest.getSession();
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
                String name = in.matchedPropertyName(attrName);
                if (name != null) {
                    Object attrValue = session.getAttribute(attrName);
                    target.writeValue(name, attrValue, true);
                }
            });
        }
    }

    @Override
    public void outject(ActionRequest actionRequest) {
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpSession session = servletRequest.getSession();
        targets.forEachTargetAndOutScopes(SCOPE_TYPE, (target, out) -> {
            Object value = target.readTargetProperty((ScopeData.Out)out);
            session.setAttribute(out.name, value);
        });
    }
}

