/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jodd.db.DbCallResult;
import jodd.db.DbQueryConfig;
import jodd.db.DbQueryParser;
import jodd.db.DbSession;
import jodd.db.DbSessionProvider;
import jodd.db.DbSqlException;
import jodd.db.DbUtil;
import jodd.db.QueryMapper;
import jodd.db.debug.LogabbleStatementFactory;
import jodd.log.Logger;
import jodd.log.LoggerFactory;

abstract class DbQueryBase<Q extends DbQueryBase>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(DbQueryBase.class);
    protected State queryState = State.CREATED;
    protected Connection connection;
    protected DbSession session;
    protected String sqlString;
    protected Statement statement;
    protected PreparedStatement preparedStatement;
    protected CallableStatement callableStatement;
    protected Set<ResultSet> resultSets;
    protected DbQueryParser query;
    protected boolean forcePreparedStatement;
    protected boolean autoClose;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    protected int type;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    protected int concurrencyType;
    public static final int DEFAULT_HOLDABILITY = -1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    protected int holdability;
    protected boolean debug;
    protected String[] generatedColumns;
    protected int fetchSize;
    protected int maxRows;
    protected long start;
    protected long elapsed = -1L;
    protected static int totalOpenResultSetCount;

    protected DbQueryBase(DbQueryConfig dbQueryConfig, boolean debug) {
        this.forcePreparedStatement = dbQueryConfig.isForcePreparedStatement();
        this.type = dbQueryConfig.getType();
        this.concurrencyType = dbQueryConfig.getConcurrencyType();
        this.holdability = dbQueryConfig.getHoldability();
        this.debug = debug;
        this.fetchSize = dbQueryConfig.getFetchSize();
        this.maxRows = dbQueryConfig.getMaxRows();
    }

    public State getQueryState() {
        return this.queryState;
    }

    protected void checkNotClosed() {
        if (this.queryState == State.CLOSED) {
            throw new DbSqlException(this, "Query is closed. Operation may be performed only on active queries.");
        }
    }

    protected void checkCreated() {
        if (this.queryState != State.CREATED) {
            String message = this.queryState == State.INITIALIZED ? "Query is already initialized." : "Query is closed.";
            throw new DbSqlException(this, message + " Operation may be performed only on created queries.");
        }
    }

    protected void checkInitialized() {
        if (this.queryState != State.INITIALIZED) {
            String message = this.queryState == State.CREATED ? "Query is created but not yet initialized." : "Query is closed.";
            throw new DbSqlException(this, message + " Operation may be performed only on initialized queries.");
        }
    }

    public boolean isClosed() {
        return this.queryState == State.CLOSED;
    }

    public boolean isActive() {
        return this.queryState != State.CLOSED;
    }

    public boolean isInitialized() {
        return this.queryState == State.INITIALIZED;
    }

    public DbSession getSession() {
        return this.session;
    }

    protected void saveResultSet(ResultSet rs) {
        if (this.resultSets == null) {
            this.resultSets = new HashSet<ResultSet>();
        }
        this.resultSets.add(rs);
    }

    public Q forcePreparedStatement() {
        this.checkCreated();
        this.forcePreparedStatement = true;
        return (Q)this;
    }

    public final void init() {
        this.checkNotClosed();
        if (this.queryState == State.INITIALIZED) {
            return;
        }
        this.initializeJdbc();
        this.queryState = State.INITIALIZED;
        this.prepareQuery();
    }

    protected void initSession(DbSession session) {
        if (session != null) {
            this.session = session;
            return;
        }
        DbSessionProvider dbSessionProvider = DbSessionProvider.get();
        if (dbSessionProvider == null) {
            throw new DbSqlException("Session provider not available.");
        }
        this.session = dbSessionProvider.getDbSession();
    }

    protected void initializeJdbc() {
        if (this.connection == null) {
            this.initSession(this.session);
            this.connection = this.session.getConnection();
        }
        this.query = new DbQueryParser(this.sqlString);
        if (this.query.callable) {
            try {
                this.callableStatement = this.debug ? (this.holdability != -1 ? LogabbleStatementFactory.callable().prepareCall(this.connection, this.query.sql, this.type, this.concurrencyType, this.holdability) : LogabbleStatementFactory.callable().prepareCall(this.connection, this.query.sql, this.type, this.concurrencyType)) : (this.holdability != -1 ? this.connection.prepareCall(this.query.sql, this.type, this.concurrencyType, this.holdability) : this.connection.prepareCall(this.query.sql, this.type, this.concurrencyType));
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Error creating callable statement", sex);
            }
            this.preparedStatement = this.callableStatement;
            this.statement = this.callableStatement;
            return;
        }
        if (this.query.prepared || this.forcePreparedStatement) {
            try {
                this.preparedStatement = this.debug ? (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? LogabbleStatementFactory.prepared().create(this.connection, this.query.sql, 1) : LogabbleStatementFactory.prepared().create(this.connection, this.query.sql, this.generatedColumns)) : (this.holdability != -1 ? LogabbleStatementFactory.prepared().create(this.connection, this.query.sql, this.type, this.concurrencyType, this.holdability) : LogabbleStatementFactory.prepared().create(this.connection, this.query.sql, this.type, this.concurrencyType))) : (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? this.connection.prepareStatement(this.query.sql, 1) : this.connection.prepareStatement(this.query.sql, this.generatedColumns)) : (this.holdability != -1 ? this.connection.prepareStatement(this.query.sql, this.type, this.concurrencyType, this.holdability) : this.connection.prepareStatement(this.query.sql, this.type, this.concurrencyType)));
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Error creating prepared statement", sex);
            }
            this.statement = this.preparedStatement;
            return;
        }
        try {
            this.statement = this.holdability != -1 ? this.connection.createStatement(this.type, this.concurrencyType, this.holdability) : this.connection.createStatement(this.type, this.concurrencyType);
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Error creating statement", sex);
        }
    }

    protected void prepareQuery() {
        if (this.fetchSize != 0) {
            this.setFetchSize(this.fetchSize);
        }
        if (this.maxRows != 0) {
            this.setMaxRows(this.maxRows);
        }
    }

    public Q autoClose() {
        this.autoClose = true;
        return (Q)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLException closeQueryResultSets() {
        SQLException sqlException = null;
        if (this.resultSets != null) {
            for (ResultSet rs : this.resultSets) {
                try {
                    rs.close();
                }
                catch (SQLException sex) {
                    if (sqlException == null) {
                        sqlException = sex;
                        continue;
                    }
                    sqlException.setNextException(sex);
                }
                finally {
                    --totalOpenResultSetCount;
                }
            }
            this.resultSets.clear();
            this.resultSets = null;
        }
        return sqlException;
    }

    public Q closeAllResultSets() {
        SQLException sex = this.closeQueryResultSets();
        if (sex != null) {
            throw new DbSqlException("Close associated ResultSets error", sex);
        }
        return (Q)this;
    }

    protected SQLException closeQuery() {
        SQLException sqlException = this.closeQueryResultSets();
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sex) {
                if (sqlException == null) {
                    sqlException = sex;
                }
                sqlException.setNextException(sex);
            }
            this.statement = null;
        }
        this.query = null;
        this.queryState = State.CLOSED;
        return sqlException;
    }

    @Override
    public void close() {
        SQLException sqlException = this.closeQuery();
        this.connection = null;
        if (this.session != null) {
            this.session.detachQuery(this);
        }
        if (sqlException != null) {
            throw new DbSqlException("Close query error", sqlException);
        }
    }

    public void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        if (!this.resultSets.remove(rs)) {
            throw new DbSqlException(this, "ResultSet is not created by this query");
        }
        try {
            rs.close();
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Close result set error", sex);
        }
        finally {
            --totalOpenResultSetCount;
        }
    }

    public int getType() {
        return this.type;
    }

    public Q setType(int type) {
        this.checkCreated();
        this.type = type;
        return (Q)this;
    }

    public Q typeForwardOnly() {
        this.setType(1003);
        return (Q)this;
    }

    public Q typeScrollSensitive() {
        this.setType(1005);
        return (Q)this;
    }

    public Q typeScrollInsensitive() {
        this.setType(1005);
        return (Q)this;
    }

    public int getConcurrencyType() {
        return this.concurrencyType;
    }

    public Q setConcurrencyType(int concurrencyType) {
        this.checkCreated();
        this.concurrencyType = concurrencyType;
        return (Q)this;
    }

    public Q concurrentReadOnly() {
        this.setConcurrencyType(1007);
        return (Q)this;
    }

    public Q concurrentUpdatable() {
        this.setConcurrencyType(1008);
        return (Q)this;
    }

    public int getHoldability() {
        return this.holdability;
    }

    public Q setHoldability(int holdability) {
        this.checkCreated();
        this.holdability = holdability;
        return (Q)this;
    }

    public Q holdCursorsOverCommit() {
        this.setHoldability(1);
        return (Q)this;
    }

    public Q closeCursorsAtCommit() {
        this.setHoldability(2);
        return (Q)this;
    }

    public boolean isInDebugMode() {
        return this.debug;
    }

    public Q setDebug(boolean debug) {
        this.checkCreated();
        this.debug = debug;
        return (Q)this;
    }

    public Q setDebugMode() {
        this.setDebug(true);
        return (Q)this;
    }

    public String[] getGeneratedColumnNames() {
        return this.generatedColumns;
    }

    public Q setGeneratedColumns(String ... columns) {
        this.checkCreated();
        this.generatedColumns = columns;
        return (Q)this;
    }

    public Q setGeneratedKey() {
        this.setGeneratedColumns(new String[0]);
        return (Q)this;
    }

    public Q resetGeneratedColumns() {
        this.checkCreated();
        this.generatedColumns = null;
        return (Q)this;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Q setFetchSize(int rows) {
        this.checkNotClosed();
        this.fetchSize = rows;
        if (this.statement != null) {
            try {
                this.statement.setFetchSize(this.fetchSize);
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Unable to set fetch size: " + this.fetchSize, sex);
            }
        }
        return (Q)this;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Q setMaxRows(int maxRows) {
        this.checkNotClosed();
        this.maxRows = maxRows;
        if (this.statement != null) {
            try {
                this.statement.setMaxRows(maxRows);
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Unable to set max rows: " + maxRows, sex);
            }
        }
        return (Q)this;
    }

    public long getExecutionTime() {
        return this.elapsed;
    }

    public ResultSet execute() {
        this.start = System.currentTimeMillis();
        this.init();
        ResultSet rs = null;
        if (log.isDebugEnabled()) {
            log.debug("Executing statement: " + this.getQueryString());
        }
        try {
            rs = this.preparedStatement == null ? this.statement.executeQuery(this.query.sql) : this.preparedStatement.executeQuery();
            rs.setFetchSize(this.fetchSize);
        }
        catch (SQLException sex) {
            DbUtil.close(rs);
            throw new DbSqlException(this, "Query execution failed", sex);
        }
        this.saveResultSet(rs);
        ++totalOpenResultSetCount;
        this.elapsed = System.currentTimeMillis() - this.start;
        if (log.isDebugEnabled()) {
            log.debug("execution time: " + this.elapsed + "ms");
        }
        return rs;
    }

    public DbCallResult executeCall() {
        this.start = System.currentTimeMillis();
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("Calling statement: " + this.getQueryString());
        }
        try {
            this.callableStatement.execute();
        }
        catch (SQLException sex) {
            DbUtil.close(this.callableStatement);
            throw new DbSqlException(this, "Query execution failed", sex);
        }
        this.elapsed = System.currentTimeMillis() - this.start;
        if (log.isDebugEnabled()) {
            log.debug("execution time: " + this.elapsed + "ms");
        }
        return new DbCallResult(this.query, this.callableStatement);
    }

    public int executeUpdate() {
        return this.executeUpdate(this.autoClose);
    }

    protected int executeUpdate(boolean closeQuery) {
        int result;
        this.start = System.currentTimeMillis();
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("Executing update: " + this.getQueryString());
        }
        try {
            result = this.preparedStatement == null ? (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? this.statement.executeUpdate(this.query.sql, 1) : this.statement.executeUpdate(this.query.sql, this.generatedColumns)) : this.statement.executeUpdate(this.query.sql)) : this.preparedStatement.executeUpdate();
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Query execution failed", sex);
        }
        if (closeQuery) {
            this.close();
        }
        this.elapsed = System.currentTimeMillis() - this.start;
        if (log.isDebugEnabled()) {
            log.debug("execution time: " + this.elapsed + "ms");
        }
        return result;
    }

    public long executeCount() {
        return this.executeCount(this.autoClose);
    }

    protected long executeCount(boolean close) {
        long l;
        this.start = System.currentTimeMillis();
        this.init();
        ResultSet rs = null;
        if (log.isDebugEnabled()) {
            log.debug("Executing prepared count: " + this.getQueryString());
        }
        try {
            rs = this.preparedStatement == null ? this.statement.executeQuery(this.query.sql) : this.preparedStatement.executeQuery();
            long firstLong = DbUtil.getFirstLong(rs);
            this.elapsed = System.currentTimeMillis() - this.start;
            if (log.isDebugEnabled()) {
                log.debug("execution time: " + this.elapsed + "ms");
            }
            l = firstLong;
        }
        catch (SQLException sex) {
            try {
                throw new DbSqlException(this, "Count query failed", sex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                if (close) {
                    this.close();
                }
                throw throwable;
            }
        }
        DbUtil.close(rs);
        if (close) {
            this.close();
        }
        return l;
    }

    public <T> List<T> list(QueryMapper<T> queryMapper) {
        ResultSet resultSet = this.execute();
        ArrayList<T> list = new ArrayList<T>();
        try {
            while (resultSet.next()) {
                T t = queryMapper.process(resultSet);
                if (t == null) {
                    break;
                }
                list.add(t);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(sex);
        }
        finally {
            DbUtil.close(resultSet);
        }
        return list;
    }

    public <T> T find(QueryMapper<T> queryMapper) {
        ResultSet resultSet = this.execute();
        try {
            if (resultSet.next()) {
                T t = queryMapper.process(resultSet);
                return t;
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(sex);
        }
        finally {
            DbUtil.close(resultSet);
        }
        return null;
    }

    public <T> Set<T> listSet(QueryMapper<T> queryMapper) {
        ResultSet resultSet = this.execute();
        HashSet<T> set = new HashSet<T>();
        try {
            while (resultSet.next()) {
                T t = queryMapper.process(resultSet);
                if (t == null) {
                    break;
                }
                set.add(t);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(sex);
        }
        finally {
            DbUtil.close(resultSet);
        }
        return set;
    }

    public ResultSet getGeneratedColumns() {
        ResultSet rs;
        this.checkInitialized();
        if (this.generatedColumns == null) {
            throw new DbSqlException(this, "No column is specified as auto-generated");
        }
        try {
            rs = this.statement.getGeneratedKeys();
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "No generated keys", sex);
        }
        this.saveResultSet(rs);
        ++totalOpenResultSetCount;
        return rs;
    }

    public long getGeneratedKey() {
        this.checkInitialized();
        ResultSet rs = this.getGeneratedColumns();
        try {
            long l = DbUtil.getFirstLong(rs);
            return l;
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "No generated key as long", sex);
        }
        finally {
            DbUtil.close(rs);
            this.resultSets.remove(rs);
            --totalOpenResultSetCount;
        }
    }

    public String getQueryString() {
        if (this.debug) {
            if (this.callableStatement != null) {
                return LogabbleStatementFactory.callable().getQueryString(this.callableStatement);
            }
            if (this.preparedStatement != null) {
                return LogabbleStatementFactory.prepared().getQueryString(this.preparedStatement);
            }
        }
        if (this.query != null) {
            return this.query.sql;
        }
        return this.sqlString;
    }

    public String toString() {
        return this.getQueryString();
    }

    public static int getTotalOpenResultSetCount() {
        return totalOpenResultSetCount;
    }

    public int getOpenResultSetCount() {
        return this.resultSets == null ? 0 : this.resultSets.size();
    }

    public static enum State {
        CREATED,
        INITIALIZED,
        CLOSED;

    }
}

