/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import jodd.db.DbQueryBase;
import jodd.db.DbSqlException;
import jodd.db.DbTransactionMode;
import jodd.db.JoddDb;
import jodd.db.connection.ConnectionProvider;
import jodd.log.Logger;
import jodd.log.LoggerFactory;

public class DbSession
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(DbSession.class);
    protected final ConnectionProvider connectionProvider;
    protected Connection connection;
    protected Set<DbQueryBase> queries;
    protected boolean txActive;
    protected DbTransactionMode txMode;

    public DbSession() {
        this(null);
    }

    public DbSession(ConnectionProvider connectionProvider) {
        log.debug("Creating new db session");
        if (connectionProvider == null && (connectionProvider = ConnectionProvider.get()) == null) {
            throw new DbSqlException("Connection provider is not available");
        }
        this.connectionProvider = connectionProvider;
        this.txActive = false;
        this.txMode = JoddDb.get().defaults().getTransactionMode();
        this.queries = new HashSet<DbQueryBase>();
    }

    public void closeSession() {
        log.debug("Closing db session");
        SQLException sqlException = null;
        if (this.queries != null) {
            for (DbQueryBase query : this.queries) {
                SQLException sex = query.closeQuery();
                if (sex == null) continue;
                if (sqlException == null) {
                    sqlException = sex;
                    continue;
                }
                sqlException.setNextException(sex);
            }
        }
        if (this.connection != null) {
            if (this.txActive) {
                throw new DbSqlException("TX was not closed before closing the session");
            }
            this.connectionProvider.closeConnection(this.connection);
            this.connection = null;
        }
        this.queries = null;
        if (sqlException != null) {
            throw new DbSqlException("Closing DbSession failed", sqlException);
        }
    }

    @Override
    public void close() throws Exception {
        this.closeSession();
    }

    public boolean isSessionClosed() {
        return this.queries == null;
    }

    public boolean isSessionOpen() {
        return this.queries != null;
    }

    public int getTotalQueries() {
        if (this.queries == null) {
            return 0;
        }
        return this.queries.size();
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void attachQuery(DbQueryBase query) {
        this.checkOpenSession();
        this.openConnectionForQuery();
        this.queries.add(query);
    }

    protected void detachQuery(DbQueryBase query) {
        this.queries.remove(query);
    }

    protected void openConnectionForQuery() {
        if (this.connection == null) {
            this.connection = this.connectionProvider.getConnection();
            this.txActive = false;
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sex) {
                throw new DbSqlException("Failed to open non-TX connection", sex);
            }
        }
    }

    public boolean isTransactionActive() {
        return this.txActive;
    }

    protected void openTx() {
        if (this.connection == null) {
            this.connection = this.connectionProvider.getConnection();
        }
        this.txActive = true;
        try {
            this.connection.setAutoCommit(false);
            if (this.txMode.getIsolation() != -1) {
                this.connection.setTransactionIsolation(this.txMode.getIsolation());
            }
            this.connection.setReadOnly(this.txMode.isReadOnly());
        }
        catch (SQLException sex) {
            throw new DbSqlException("Open TX failed", sex);
        }
    }

    protected void closeTx() {
        this.txActive = false;
        try {
            this.connection.setAutoCommit(true);
        }
        catch (SQLException sex) {
            throw new DbSqlException("Close TX failed", sex);
        }
    }

    public void beginTransaction(DbTransactionMode mode) {
        log.debug("Beginning transaction");
        this.checkClosedTx();
        this.txMode = mode;
        this.openTx();
    }

    public void beginTransaction() {
        this.beginTransaction(JoddDb.get().defaults().getTransactionMode());
    }

    public void commitTransaction() {
        log.debug("Committing transaction");
        this.checkActiveTx();
        try {
            this.connection.commit();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Commit TX failed", sex);
        }
        finally {
            this.closeTx();
        }
    }

    public void rollbackTransaction() {
        log.debug("Rolling-back transaction");
        this.checkActiveTx();
        try {
            this.connection.rollback();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Rollback TX failed", sex);
        }
        finally {
            this.closeTx();
        }
    }

    protected void checkOpenSession() {
        if (this.queries == null) {
            throw new DbSqlException("Session is closed");
        }
    }

    protected void checkClosedTx() {
        this.checkOpenSession();
        if (this.txActive) {
            throw new DbSqlException("TX already started for this session");
        }
    }

    protected void checkActiveTx() {
        this.checkOpenSession();
        if (!this.txActive) {
            throw new DbSqlException("TX not available for this session");
        }
    }
}

