/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.naming;

import jodd.db.oom.naming.BaseNamingStrategy;
import jodd.util.StringUtil;

public class TableNamingStrategy
extends BaseNamingStrategy {
    protected String prefix = "";
    protected String suffix = "";
    protected char entityNameTerminator = (char)36;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public char getEntityNameTerminator() {
        return this.entityNameTerminator;
    }

    public void setEntityNameTerminator(char entityNameTerminator) {
        this.entityNameTerminator = entityNameTerminator;
    }

    public String convertEntityNameToTableName(Class type) {
        return this.convertEntityNameToTableName(type.getSimpleName());
    }

    public String convertEntityNameToTableName(String entityName) {
        int ndx = entityName.indexOf(this.entityNameTerminator);
        if (ndx != -1) {
            entityName = entityName.substring(0, ndx);
        }
        StringBuilder tableName = new StringBuilder(entityName.length() * 2);
        if (this.prefix != null) {
            tableName.append(this.prefix);
        }
        if (this.splitCamelCase) {
            String convertedTableName = StringUtil.fromCamelCase(entityName, this.separatorChar);
            tableName.append(convertedTableName);
        } else {
            tableName.append(entityName);
        }
        if (this.suffix != null) {
            tableName.append(this.suffix);
        }
        if (!this.changeCase) {
            return tableName.toString();
        }
        return this.uppercase ? TableNamingStrategy.toUppercase(tableName).toString() : TableNamingStrategy.toLowercase(tableName).toString();
    }

    public String convertTableNameToEntityName(String tableName) {
        StringBuilder className = new StringBuilder(tableName.length());
        int len = tableName.length();
        int i = 0;
        if (this.prefix != null && tableName.startsWith(this.prefix)) {
            i = this.prefix.length();
        }
        if (this.suffix != null && tableName.endsWith(this.suffix)) {
            len -= this.suffix.length();
        }
        if (this.splitCamelCase) {
            boolean toUpper = true;
            while (i < len) {
                char c = tableName.charAt(i);
                if (c == this.separatorChar) {
                    toUpper = true;
                } else if (toUpper) {
                    className.append(Character.toUpperCase(c));
                    toUpper = false;
                } else {
                    className.append(Character.toLowerCase(c));
                }
                ++i;
            }
            return className.toString();
        }
        return tableName.substring(i, len);
    }

    public String applyToTableName(String tableName) {
        String entityName = this.convertTableNameToEntityName(tableName);
        return this.convertEntityNameToTableName(entityName);
    }
}

