/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen.chunks;

import jodd.bean.BeanUtil;
import jodd.db.JoddDb;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.sqlgen.chunks.SqlChunk;
import jodd.util.StringUtil;

public class InsertChunk
extends SqlChunk {
    protected final String entityName;
    protected final Class entityType;
    protected final Object data;

    public InsertChunk(String entityName, Object data) {
        this(entityName, null, data);
    }

    public InsertChunk(Class entityType, Object data) {
        this(null, entityType, data);
    }

    protected InsertChunk(String entityName, Class entityType, Object data) {
        super(5);
        this.entityName = entityName;
        this.entityType = entityType;
        this.data = data;
    }

    @Override
    public void process(StringBuilder out) {
        DbEntityDescriptor ded = this.entityName != null ? this.lookupName(this.entityName) : this.lookupType(this.entityType);
        StringBuilder col = new StringBuilder();
        StringBuilder val = new StringBuilder();
        DbEntityColumnDescriptor[] decList = ded.getColumnDescriptors();
        String typeName = StringUtil.uncapitalize(ded.getEntityName());
        int size = 0;
        for (DbEntityColumnDescriptor dec : decList) {
            String property;
            Object value;
            boolean defaultIsUpdateablePrimaryKey = JoddDb.get().defaults().getSqlGenConfig().isUpdateablePrimaryKey();
            if (dec.isId() && !defaultIsUpdateablePrimaryKey || (value = BeanUtil.declared.getProperty(this.data, property = dec.getPropertyName())) == null) continue;
            if (size > 0) {
                col.append(',').append(' ');
                val.append(',').append(' ');
            }
            ++size;
            col.append(dec.getColumnName());
            String propertyName = typeName + '.' + property;
            this.defineParameter(val, propertyName, value, dec);
        }
        out.append("insert into ").append(ded.getTableName()).append(" (").append((CharSequence)col).append(") values (").append((CharSequence)val).append(')');
    }
}

