/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.querymap;

import jodd.db.JoddDb;
import jodd.db.querymap.QueryMap;
import jodd.props.Props;
import jodd.props.PropsUtil;

public class DbPropsQueryMap
implements QueryMap {
    protected final String[] patterns;
    protected Props props;

    public DbPropsQueryMap(String ... patterns) {
        this.patterns = patterns;
        this.loadQueriesFromClasspath();
    }

    public DbPropsQueryMap() {
        this("*.sql.props", "*.oom.props", "*.sql.properties", "*.oom.properties");
    }

    public Props props() {
        return this.props;
    }

    public void loadQueriesFromClasspath() {
        this.props = PropsUtil.createFromClasspath(this.patterns);
    }

    @Override
    public String getQuery(String key) {
        if (JoddDb.get().defaults().isDebug()) {
            this.loadQueriesFromClasspath();
        }
        return this.props.getValue(key);
    }
}

