/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.injector.Target;
import jodd.madvoc.meta.RenderWith;
import jodd.madvoc.result.ActionResult;
import jodd.madvoc.result.Chain;
import jodd.madvoc.result.Forward;
import jodd.madvoc.result.PermanentRedirect;
import jodd.madvoc.result.Redirect;
import jodd.petite.meta.PetiteInject;
import jodd.util.ClassUtil;

public class ResultsManager {
    private static final Logger log = LoggerFactory.getLogger(ResultsManager.class);
    @PetiteInject
    protected ContextInjectorComponent contextInjectorComponent;
    @PetiteInject
    protected MadvocConfig madvocConfig;
    protected String defaultResultName;
    protected final Map<String, Function<String, Object>> stringResultsFactories = new HashMap<String, Function<String, Object>>();
    protected final Map<Class<? extends ActionResult>, ActionResult> allResults = new HashMap<Class<? extends ActionResult>, ActionResult>();

    public ResultsManager() {
        this.registerResultName("chain", Chain::to);
        this.registerResultName("redirect", Redirect::to);
        this.registerResultName("url", PermanentRedirect::to);
        this.registerResultName("dispatch", Forward::to);
        this.setDefaultResultName("dispatch");
    }

    public Set<ActionResult> getAllActionResults() {
        HashSet<ActionResult> set = new HashSet<ActionResult>(this.allResults.size());
        set.addAll(this.allResults.values());
        return set;
    }

    public void registerResultName(String name, Function<String, Object> factory) {
        this.stringResultsFactories.put(name, factory);
    }

    public ActionResult register(Class<? extends ActionResult> resultClass) {
        return this.register(this.createResult(resultClass));
    }

    protected ActionResult register(ActionResult result) {
        Class<?> actionResultClass = result.getClass();
        ActionResult existingResult = this.allResults.get(actionResultClass);
        if (existingResult != null) {
            if (log.isDebugEnabled()) {
                log.debug("ActionResult already registered: " + actionResultClass);
            }
            return existingResult;
        }
        this.allResults.put(actionResultClass, result);
        this.initializeResult(result);
        return result;
    }

    private ActionResult lookupAndRegisterIfMissing(Class<? extends ActionResult> actionResultClass) {
        ActionResult actionResult = this.allResults.get(actionResultClass);
        if (actionResult == null) {
            actionResult = this.register(actionResultClass);
        }
        return actionResult;
    }

    public ActionResult lookup(ActionRequest actionRequest, Object resultObject) {
        ActionConfig actionConfig;
        RenderWith renderWith;
        ActionRuntime actionRuntime;
        Class<? extends ActionResult> actionResultClass;
        ActionResult actionResultHandler;
        boolean modifiedResultObject = false;
        if (resultObject == null || resultObject instanceof String) {
            Function<String, Object> function;
            int columnIndex;
            String resultName = this.defaultResultName;
            String resultValue = "";
            if (resultObject != null && (columnIndex = (resultValue = resultObject.toString()).indexOf(58)) != -1) {
                resultName = resultValue.substring(0, columnIndex);
                resultValue = resultValue.substring(columnIndex + 1);
            }
            if ((function = this.stringResultsFactories.get(resultName)) == null) {
                throw new MadvocException("Invalid result name:" + resultName);
            }
            resultObject = function.apply(resultValue);
            modifiedResultObject = true;
        }
        if ((actionResultHandler = null) == null && (actionResultClass = (actionRuntime = actionRequest.getActionRuntime()).getActionResult()) != null) {
            actionResultHandler = this.lookupAndRegisterIfMissing(actionResultClass);
        }
        if (actionResultHandler == null && (renderWith = resultObject.getClass().getAnnotation(RenderWith.class)) != null) {
            actionResultHandler = this.lookupAndRegisterIfMissing(renderWith.value());
        }
        if ((actionResultHandler == null || modifiedResultObject) && (actionResultClass = (actionConfig = actionRequest.getActionRuntime().getActionConfig()).getActionResult()) != null) {
            actionResultHandler = this.lookupAndRegisterIfMissing(actionResultClass);
        }
        if (actionResultHandler == null) {
            throw new MadvocException("ActionResult not found for: " + resultObject);
        }
        actionRequest.bindActionResult(resultObject);
        return actionResultHandler;
    }

    public String getDefaultResultName() {
        return this.defaultResultName;
    }

    public void setDefaultResultName(String defaultResultName) {
        this.defaultResultName = defaultResultName;
    }

    protected void initializeResult(ActionResult result) {
        this.contextInjectorComponent.injectContext(new Target(result));
    }

    protected ActionResult createResult(Class<? extends ActionResult> actionResultClass) {
        try {
            return ClassUtil.newInstance(actionResultClass);
        }
        catch (Exception ex) {
            throw new MadvocException("Invalid Madvoc result: " + actionResultClass, ex);
        }
    }
}

