/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.io.IOException;
import java.util.stream.Collectors;
import jodd.json.JsonParser;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeType;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Targets;
import jodd.util.StringUtil;

public class RequestBodyScopeInject
implements Injector {
    private static final ScopeType SCOPE_TYPE = ScopeType.BODY;

    @Override
    public void inject(ActionRequest actionRequest) {
        String body;
        Targets targets = actionRequest.getTargets();
        if (!targets.usesScope(SCOPE_TYPE)) {
            return;
        }
        try {
            body = actionRequest.getHttpServletRequest().getReader().lines().collect(Collectors.joining());
        }
        catch (IOException ignore) {
            return;
        }
        if (StringUtil.isEmpty(body)) {
            return;
        }
        targets.forEachTargetAndInScopes(SCOPE_TYPE, (target, in) -> {
            Object value = JsonParser.create().parse(body, in.type);
            target.writeValue(in.propertyName(), value, true);
        });
    }
}

