/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import jodd.mail.EmailFilter;
import jodd.mail.EmailUtil;
import jodd.mail.MailException;
import jodd.mail.MailSession;
import jodd.mail.ReceivedEmail;

public class ReceiveMailSession
extends MailSession<Store> {
    protected static final String DEFAULT_FOLDER = "INBOX";
    private Folder folder;

    public ReceiveMailSession(Session session, Store store) {
        super(session, (Service)store);
    }

    @Override
    public Store getService() {
        return (Store)this.service;
    }

    public String[] getAllFolders() {
        Folder[] folders;
        try {
            folders = this.getService().getDefaultFolder().list("*");
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to connect to folder", msgexc);
        }
        String[] folderNames = new String[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            Folder folder = folders[i];
            folderNames[i] = folder.getFullName();
        }
        return folderNames;
    }

    public void useFolder(String folderName) {
        this.closeFolderIfOpened();
        try {
            this.folder = this.getService().getFolder(folderName);
            try {
                this.openFolder(2, folderName);
            }
            catch (MailException ignore) {
                this.openFolder(1, folderName);
            }
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to connect to folder: " + folderName, msgexc);
        }
    }

    private void openFolder(int mode, String folderNameForErr) throws MailException {
        try {
            this.folder.open(mode);
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to open folder: " + folderNameForErr, msgexc);
        }
    }

    public void useDefaultFolder() {
        this.closeFolderIfOpened();
        this.useFolder(DEFAULT_FOLDER);
    }

    public int getMessageCount() {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            return this.folder.getMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public int getNewMessageCount() {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            return this.folder.getNewMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public int getUnreadMessageCount() {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            return this.folder.getUnreadMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public int getDeletedMessageCount() {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            return this.folder.getDeletedMessageCount();
        }
        catch (MessagingException msgexc) {
            throw new MailException(msgexc);
        }
    }

    public ReceivedEmail[] receiveEmail() {
        return this.receive(null, null);
    }

    public ReceivedEmail[] receiveEmail(EmailFilter filter) {
        return this.receive(filter, null);
    }

    public ReceivedEmail[] receiveEmailAndMarkSeen() {
        return this.receiveEmailAndMarkSeen(null);
    }

    public ReceivedEmail[] receiveEmailAndMarkSeen(EmailFilter filter) {
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        return this.receive(filter, flags);
    }

    public ReceivedEmail[] receiveEmailAndDelete() {
        return this.receiveEmailAndDelete(null);
    }

    public ReceivedEmail[] receiveEmailAndDelete(EmailFilter filter) {
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        flags.add(Flags.Flag.DELETED);
        return this.receive(filter, flags);
    }

    public ReceivedEmail[] receive(EmailFilter filter, Flags flagsToSet) {
        if (this.folder == null) {
            this.useDefaultFolder();
        }
        try {
            Message[] messages = filter == null ? this.folder.getMessages() : this.folder.search(filter.getSearchTerm());
            if (messages.length == 0) {
                return ReceivedEmail.EMPTY_ARRAY;
            }
            ReceivedEmail[] emails = new ReceivedEmail[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                Message msg = messages[i];
                emails[i] = new ReceivedEmail(msg);
                if (flagsToSet != null) {
                    emails[i].flags(flagsToSet);
                    msg.setFlags(flagsToSet, true);
                }
                if (flagsToSet != null || emails[i].isSeen()) continue;
                msg.setFlag(Flags.Flag.SEEN, false);
            }
            return emails;
        }
        catch (MessagingException msgexc) {
            throw new MailException("Failed to fetch messages", msgexc);
        }
    }

    protected void closeFolderIfOpened() {
        if (this.folder != null) {
            try {
                this.folder.close(true);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        this.closeFolderIfOpened();
        super.close();
    }

    static {
        EmailUtil.setupSystemMailProperties();
    }
}

