/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.scope;

import java.util.HashMap;
import java.util.Map;
import jodd.petite.BeanData;
import jodd.petite.BeanDefinition;
import jodd.petite.scope.ProtoScope;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SingletonScope;

public class ThreadLocalScope
implements Scope {
    protected static ThreadLocal<Map<String, BeanData>> context = new ThreadLocal<Map<String, BeanData>>(){

        @Override
        protected synchronized Map<String, BeanData> initialValue() {
            return new HashMap<String, BeanData>();
        }
    };

    @Override
    public Object lookup(String name) {
        Map<String, BeanData> threadLocalMap = context.get();
        BeanData beanData = threadLocalMap.get(name);
        if (beanData == null) {
            return null;
        }
        return beanData.instance();
    }

    @Override
    public void register(BeanDefinition beanDefinition, Object bean) {
        BeanData beanData = new BeanData(beanDefinition, bean);
        Map<String, BeanData> threadLocalMap = context.get();
        threadLocalMap.put(beanDefinition.name(), beanData);
    }

    @Override
    public void remove(String name) {
        Map<String, BeanData> threadLocalMap = context.get();
        threadLocalMap.remove(name);
    }

    @Override
    public boolean accept(Scope referenceScope) {
        Class<?> refScopeType = referenceScope.getClass();
        if (refScopeType == ProtoScope.class) {
            return true;
        }
        if (refScopeType == SingletonScope.class) {
            return true;
        }
        return refScopeType == ThreadLocalScope.class;
    }

    @Override
    public void shutdown() {
    }
}

