/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jodd.io.FastCharArrayWriter;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.props.PropsData;
import jodd.props.PropsEntries;
import jodd.props.PropsEntry;
import jodd.props.PropsParser;
import jodd.util.StringPool;
import jodd.util.StringUtil;
import jodd.util.Wildcard;

public class Props
implements Cloneable {
    private static final String DEFAULT_PROFILES_PROP = "@profiles";
    protected final PropsParser parser;
    protected final PropsData data;
    protected String activeProfilesProp = "@profiles";
    protected String[] activeProfiles;
    protected volatile boolean initialized;

    public Props() {
        this(new PropsParser());
    }

    protected Props(PropsParser parser) {
        this.parser = parser;
        this.data = parser.getPropsData();
    }

    protected Props clone() {
        PropsParser parser = this.parser.clone();
        Props p = new Props(parser);
        p.activeProfilesProp = this.activeProfilesProp;
        return p;
    }

    public String[] getActiveProfiles() {
        this.initialize();
        return this.activeProfiles;
    }

    public Props setActiveProfiles(String ... activeProfiles) {
        this.initialized = false;
        this.activeProfiles = activeProfiles;
        return this;
    }

    public Props setEscapeNewLineValue(String escapeNewLineValue) {
        this.parser.escapeNewLineValue = escapeNewLineValue;
        return this;
    }

    public Props setValueTrimLeft(boolean valueTrimLeft) {
        this.parser.valueTrimLeft = valueTrimLeft;
        return this;
    }

    public Props setValueTrimRight(boolean valueTrimRight) {
        this.parser.valueTrimRight = valueTrimRight;
        return this;
    }

    public Props setIgnorePrefixWhitespacesOnNewLine(boolean ignorePrefixWhitespacesOnNewLine) {
        this.parser.ignorePrefixWhitespacesOnNewLine = ignorePrefixWhitespacesOnNewLine;
        return this;
    }

    public Props setSkipEmptyProps(boolean skipEmptyProps) {
        this.parser.skipEmptyProps = skipEmptyProps;
        this.data.skipEmptyProps = skipEmptyProps;
        return this;
    }

    public Props setAppendDuplicateProps(boolean appendDuplicateProps) {
        this.data.appendDuplicateProps = appendDuplicateProps;
        return this;
    }

    public Props setIgnoreMissingMacros(boolean ignoreMissingMacros) {
        this.data.ignoreMissingMacros = ignoreMissingMacros;
        return this;
    }

    public Props setMultilineValues(boolean multilineValues) {
        this.parser.multilineValues = multilineValues;
        return this;
    }

    protected synchronized void parse(String data) {
        this.initialized = false;
        this.parser.parse(data);
    }

    public void load(String data) {
        this.parse(data);
    }

    public void load(File file) throws IOException {
        String extension = FileNameUtil.getExtension(file.getAbsolutePath());
        String data = extension.equalsIgnoreCase("properties") ? FileUtil.readString(file, "ISO-8859-1") : FileUtil.readString(file);
        this.parse(data);
    }

    public void load(File file, String encoding) throws IOException {
        this.parse(FileUtil.readString(file, encoding));
    }

    public void load(InputStream in) throws IOException {
        FastCharArrayWriter out = new FastCharArrayWriter();
        StreamUtil.copy(in, out);
        this.parse(((Object)out).toString());
    }

    public void load(InputStream in, String encoding) throws IOException {
        FastCharArrayWriter out = new FastCharArrayWriter();
        StreamUtil.copy(in, out, encoding);
        this.parse(((Object)out).toString());
    }

    public void load(Map<?, ?> p) {
        for (Map.Entry<?, ?> entry : p.entrySet()) {
            String name = entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) continue;
            this.data.putBaseProperty(name, value.toString(), false);
        }
    }

    public void load(Map<?, ?> map, String prefix) {
        String realPrefix = prefix;
        realPrefix = realPrefix + '.';
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String name = entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) continue;
            this.data.putBaseProperty(realPrefix + name, value.toString(), false);
        }
    }

    public void loadSystemProperties(String prefix) {
        Properties environmentProperties = System.getProperties();
        this.load(environmentProperties, prefix);
    }

    public void loadEnvironment(String prefix) {
        Map<String, String> environmentMap = System.getenv();
        this.load(environmentMap, prefix);
    }

    public int countTotalProperties() {
        return this.data.countBaseProperties() + this.data.countProfileProperties();
    }

    public String getBaseValue(String key) {
        return this.getValue(key, StringPool.EMPTY_ARRAY);
    }

    public String getValue(String key) {
        this.initialize();
        return this.data.lookupValue(key, this.activeProfiles);
    }

    public String getValueOrDefault(String key, String defaultValue) {
        this.initialize();
        String value = this.data.lookupValue(key, this.activeProfiles);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Integer getIntegerValue(String key) {
        String value = this.getValue(key);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public Integer getIntegerValue(String key, Integer defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public Long getLongValue(String key) {
        String value = this.getValue(key);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    public Long getLongValue(String key, Long defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            return defaultValue;
        }
        return Long.valueOf(value);
    }

    public Double getDoubleValue(String key) {
        String value = this.getValue(key);
        if (value == null) {
            return null;
        }
        return Double.valueOf(value);
    }

    public Double getDoubleValue(String key, Double defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            return defaultValue;
        }
        return Double.valueOf(value);
    }

    public Boolean getBooleanValue(String key) {
        String value = this.getValue(key);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public Boolean getBooleanValue(String key, Boolean defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public String getValue(String key, String ... profiles) {
        this.initialize();
        return this.data.lookupValue(key, profiles);
    }

    public Integer getIntegerValue(String key, String ... profiles) {
        String value = this.getValue(key, profiles);
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public Integer getIntegerValue(String key, Integer defaultValue, String ... profiles) {
        String value = this.getValue(key, profiles);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public Long getLongValue(String key, String ... profiles) {
        String value = this.getValue(key, profiles);
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    public Long getLongValue(String key, Long defaultValue, String ... profiles) {
        String value = this.getValue(key, profiles);
        if (value == null) {
            return defaultValue;
        }
        return Long.valueOf(value);
    }

    public Double getDoubleValue(String key, String ... profiles) {
        String value = this.getValue(key, profiles);
        if (value == null) {
            return null;
        }
        return Double.valueOf(value);
    }

    public Double getDoubleValue(String key, Double defaultValue, String ... profiles) {
        String value = this.getValue(key, profiles);
        if (value == null) {
            return defaultValue;
        }
        return Double.valueOf(value);
    }

    public Boolean getBooleanValue(String key, String ... profiles) {
        String value = this.getValue(key, profiles);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public Boolean getBooleanValue(String key, Boolean defaultValue, String ... profiles) {
        String value = this.getValue(key, profiles);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public void setValue(String key, String value) {
        this.setValue(key, value, null);
    }

    public void setValue(String key, String value, String profile) {
        if (profile == null) {
            this.data.putBaseProperty(key, value, false);
        } else {
            this.data.putProfileProperty(key, value, profile, false);
        }
        this.initialized = false;
    }

    public void extractProps(Map target) {
        this.initialize();
        this.data.extract(target, this.activeProfiles, null, null);
    }

    public void extractProps(Map target, String ... profiles) {
        this.initialize();
        this.data.extract(target, profiles, null, null);
    }

    public void extractSubProps(Map target, String ... wildcardPatterns) {
        this.initialize();
        this.data.extract(target, this.activeProfiles, wildcardPatterns, null);
    }

    public void extractSubProps(Map target, String[] profiles, String[] wildcardPatterns) {
        this.initialize();
        this.data.extract(target, profiles, wildcardPatterns, null);
    }

    public Map<String, Object> innerMap(String prefix) {
        this.initialize();
        return this.data.extract(null, this.activeProfiles, null, prefix);
    }

    public void addInnerMap(String prefix, Map<?, ?> map) {
        this.addInnerMap(prefix, map, null);
    }

    public void addInnerMap(String prefix, Map<?, ?> map, String profile) {
        if (!StringUtil.endsWithChar(prefix, '.')) {
            prefix = prefix + ".";
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            key = prefix + key;
            this.setValue(key, entry.getValue().toString(), profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        if (!this.initialized) {
            Props props = this;
            synchronized (props) {
                if (!this.initialized) {
                    this.resolveActiveProfiles();
                    this.initialized = true;
                }
            }
        }
    }

    protected void resolveActiveProfiles() {
        if (this.activeProfilesProp == null) {
            this.activeProfiles = null;
            return;
        }
        PropsEntry pv = this.data.getBaseProperty(this.activeProfilesProp);
        if (pv == null) {
            return;
        }
        String value = pv.getValue();
        if (StringUtil.isBlank(value)) {
            this.activeProfiles = null;
            return;
        }
        this.activeProfiles = StringUtil.splitc(value, ',');
        StringUtil.trimAll(this.activeProfiles);
    }

    public String[] getAllProfiles() {
        String[] profiles = new String[this.data.profileProperties.size()];
        int index = 0;
        Iterator<String> iterator = this.data.profileProperties.keySet().iterator();
        while (iterator.hasNext()) {
            String profileName;
            profiles[index] = profileName = iterator.next();
            ++index;
        }
        return profiles;
    }

    public String[] getProfilesFor(String propKeyNameWildcard) {
        HashSet<String> profiles = new HashSet<String>();
        block0: for (Map.Entry<String, Map<String, PropsEntry>> entries : this.data.profileProperties.entrySet()) {
            String profileName = entries.getKey();
            Map<String, PropsEntry> value = entries.getValue();
            for (String propKeyName : value.keySet()) {
                if (!Wildcard.equalsOrMatch(propKeyName, propKeyNameWildcard)) continue;
                profiles.add(profileName);
                continue block0;
            }
        }
        return profiles.toArray(new String[profiles.size()]);
    }

    public PropsEntries entries() {
        this.initialize();
        return new PropsEntries(this);
    }

    public Iterator<PropsEntry> iterator() {
        return this.entries().activeProfiles().iterator();
    }
}

