// Copyright (c) 2003-present, Jodd Team (http://jodd.org)
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

package jodd.db.debug;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * Factory for loggable prepared statements - a <code>PreparedStatement</code> with added logging capability.
 * <p>
 * In addition to the methods declared in <code>PreparedStatement</code>,
 * <code>LoggablePreparedStatement</code> provides a method {@link #getQueryString} that can be used to get
 * the query string in a format suitable for logging.
 * <p>
 * Should not be used in production!
 */
@SuppressWarnings("MagicConstant")
public class LoggablePreparedStatementFactory extends BaseLoggableFactory<PreparedStatement> {

	protected LoggablePreparedStatementFactory() {
		super(PreparedStatement.class);
	}

	public PreparedStatement create(final Connection connection, final String sql) throws SQLException {
		PreparedStatement preparedStatement = connection.prepareStatement(sql);
		return wrap(preparedStatement, sql);
	}

	public PreparedStatement create(final Connection connection, final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
		PreparedStatement preparedStatement = connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
		return wrap(preparedStatement, sql);
	}

	public PreparedStatement create(final Connection connection, final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
		PreparedStatement preparedStatement = connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
		return wrap(preparedStatement, sql);
	}

	public PreparedStatement create(final Connection connection, final String sql, final int autoGeneratedKeys) throws SQLException {
		PreparedStatement preparedStatement = connection.prepareStatement(sql, autoGeneratedKeys);
		return wrap(preparedStatement, sql);
	}

	public PreparedStatement create(final Connection connection, final String sql, final int[] columnIndexes) throws SQLException {
		PreparedStatement preparedStatement = connection.prepareStatement(sql, columnIndexes);
		return wrap(preparedStatement, sql);
	}

	public PreparedStatement create(final Connection connection, final String sql, final String[] columnNames) throws SQLException {
		PreparedStatement preparedStatement = connection.prepareStatement(sql, columnNames);
		return wrap(preparedStatement, sql);
	}

}
