// Copyright (c) 2003-present, Jodd Team (http://jodd.org)
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

package jodd.madvoc;

import jodd.madvoc.meta.Scope;

/**
 * Parameters scope for injection ({@link jodd.madvoc.meta.In})
 * and outjection ({@link jodd.madvoc.meta.Out}).
 */
public enum ScopeType {
	/**
	 * Request attributes and parameters.
	 */
	REQUEST(0),
	/**
	 * Session attributes.
	 */
	SESSION(1),
	/**
	 * Servlet context attributes.
	 */
	APPLICATION(2),
	/**
	 * Madvoc context.
	 */
	CONTEXT(3),
	/**
	 * Servlet-related stuff.
	 */
	SERVLET(4),
	/**
	 * All about cookies.
	 */
	COOKIE(5),

	/**
	 * Request body.
	 */
	BODY(6)
	;

	private int value;

	ScopeType(final int value) {
		this.value = value;
	}

	public int value() {
		return value;
	}

	@Override
	public String toString() {
		switch(value) {
			case 0: return "Request";
			case 1: return "Session";
			case 2: return "Application";
			case 3: return "MadvocContext";
			case 4: return "Servlet";
			case 5: return "Cookie";
			case 6: return "Body";
			default: return "Undefined";
		}
	}

	public static ScopeType defaultOrScopeType(final Scope scope) {
		if (scope == null) {
			return REQUEST;
		}
		return scope.value();
	}
}
