/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import jodd.util.collection.MapEntry;

public class LazyMap
extends AbstractMap {
    private final boolean delayMap;
    private Map map;
    private int size;
    private Object[] keys;
    private Object[] values;

    public LazyMap() {
        this.keys = new Object[5];
        this.values = new Object[5];
        this.delayMap = false;
    }

    public LazyMap(int initialSize) {
        this.keys = new Object[initialSize];
        this.values = new Object[initialSize];
        this.delayMap = false;
    }

    public LazyMap(int initialSize, boolean delayMap) {
        this.keys = new Object[initialSize];
        this.values = new Object[initialSize];
        this.delayMap = delayMap;
    }

    public LazyMap(List keys, List values, boolean delayMap) {
        this.keys = LazyMap.array(Object.class, keys);
        this.values = LazyMap.array(Object.class, values);
        this.size = this.keys.length;
        this.delayMap = delayMap;
    }

    @Override
    public Object put(Object key, Object value) {
        if (this.map == null) {
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
            if (this.size == this.keys.length) {
                this.keys = LazyMap.grow(this.keys);
                this.values = LazyMap.grow(this.values);
            }
            return null;
        }
        return this.map.put(key, value);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        if (this.map != null) {
            this.map.entrySet();
        }
        if (this.delayMap) {
            return new FakeMapEntrySet(this.size, this.keys, this.values);
        }
        this.buildIfNeeded();
        return this.map.entrySet();
    }

    @Override
    public int size() {
        if (this.map == null) {
            return this.size;
        }
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.map == null) {
            return this.size == 0;
        }
        return this.map.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.map == null) {
            throw new RuntimeException("wrong type of map");
        }
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        this.buildIfNeeded();
        return this.map.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        this.buildIfNeeded();
        return this.map.get(key);
    }

    private void buildIfNeeded() {
        if (this.map == null) {
            this.map = new HashMap();
            for (int index = 0; index < this.size; ++index) {
                Object value = this.values[index];
                if (value instanceof Supplier) {
                    value = ((Supplier)value).get();
                }
                this.map.put(this.keys[index], value);
            }
            this.keys = null;
            this.values = null;
        }
    }

    @Override
    public Object remove(Object key) {
        this.buildIfNeeded();
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map m) {
        this.buildIfNeeded();
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        if (this.map == null) {
            this.size = 0;
        } else {
            this.map.clear();
        }
    }

    @Override
    public Set keySet() {
        if (this.map == null) {
            return LazyMap.set(this.size, this.keys);
        }
        return this.map.keySet();
    }

    @Override
    public Collection values() {
        if (this.map == null) {
            return Arrays.asList(this.values);
        }
        return this.map.values();
    }

    @Override
    public boolean equals(Object o) {
        this.buildIfNeeded();
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        this.buildIfNeeded();
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        this.buildIfNeeded();
        return this.map.toString();
    }

    @Override
    protected Object clone() {
        if (this.map == null) {
            return null;
        }
        if (this.map instanceof LinkedHashMap) {
            return ((LinkedHashMap)this.map).clone();
        }
        return LazyMap.copy(this);
    }

    public LazyMap clearAndCopy() {
        LazyMap map = new LazyMap(this.size);
        for (int index = 0; index < this.size; ++index) {
            map.put(this.keys[index], this.values[index]);
        }
        this.size = 0;
        return map;
    }

    public static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map instanceof LinkedHashMap) {
            return new LinkedHashMap<K, V>(map);
        }
        if (map instanceof ConcurrentHashMap) {
            return new ConcurrentHashMap<K, V>(map);
        }
        return new HashMap<K, V>(map);
    }

    private static <V> Set<V> set(int size, V ... array) {
        int index = 0;
        HashSet<V> set = new HashSet<V>();
        for (V v : array) {
            set.add(v);
            if (++index == size) break;
        }
        return set;
    }

    private static <V> V[] array(Class<V> cls, Collection<V> collection) {
        Object newInstance = Array.newInstance(cls, collection.size());
        return collection.toArray((Object[])newInstance);
    }

    private static <V> V[] grow(V[] array) {
        Object newArray = Array.newInstance(array.getClass().getComponentType(), array.length * 2);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return (Object[])newArray;
    }

    private static <V> List<V> list(V ... array) {
        int length = array.length;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int index = 0; index < length; ++index) {
            list.add(Array.get(array, index));
        }
        return list;
    }

    private static class FakeMapEntrySet
    extends AbstractSet<Map.Entry<Object, Object>> {
        Map.Entry<Object, Object>[] array;

        public FakeMapEntrySet(int size, Object[] keys, Object[] values) {
            this.array = new Map.Entry[size];
            for (int index = 0; index < size; ++index) {
                this.array[index] = new MapEntry<Object, Object>(keys[index], values[index]);
            }
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            return LazyMap.list(this.array).iterator();
        }

        @Override
        public int size() {
            return this.array.length;
        }
    }
}

