/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.config.RootPackages;
import jodd.madvoc.interceptor.ServletConfigInterceptor;
import jodd.madvoc.macro.PathMacros;
import jodd.madvoc.macro.RegExpPathMacros;
import jodd.madvoc.meta.Action;
import jodd.madvoc.meta.ActionAnnotation;
import jodd.madvoc.meta.ActionAnnotationData;
import jodd.madvoc.meta.ActionConfiguredBy;
import jodd.madvoc.meta.RestAction;
import jodd.madvoc.path.DefaultActionPathNamingStrategy;
import jodd.upload.FileUploadFactory;
import jodd.upload.impl.AdaptiveFileUploadFactory;
import jodd.util.ArraysUtil;
import jodd.util.ClassUtil;

public final class MadvocConfig {
    private ActionConfig actionConfig;
    private Map<Class<? extends Annotation>, ActionConfig> annotations = new HashMap<Class<? extends Annotation>, ActionConfig>();
    private Class<? extends Annotation>[] actionAnnotations = ClassUtil.emptyClassArray();
    private ActionAnnotation<?>[] actionAnnotationInstances = new ActionAnnotation[0];
    private String encoding;
    private boolean applyCharacterEncoding;
    private FileUploadFactory fileUploadFactory;
    private RootPackages rootPackages;
    private boolean detectDuplicatePathsEnabled;
    private boolean preventCaching;
    private String resultPathPrefix;
    private Class<? extends PathMacros> pathMacroClass;
    private String[] pathMacroSeparators;

    public MadvocConfig() {
        this.actionConfig = new ActionConfig(null);
        this.actionConfig.setActionMethodNames("view", "execute");
        this.actionConfig.setActionResult(null);
        this.actionConfig.setFilters(new Class[0]);
        this.actionConfig.setInterceptors(ServletConfigInterceptor.class);
        this.actionConfig.setNamingStrategy(DefaultActionPathNamingStrategy.class);
        this.setActionAnnotations(Action.class, RestAction.class);
        this.encoding = "UTF-8";
        this.applyCharacterEncoding = true;
        this.fileUploadFactory = new AdaptiveFileUploadFactory();
        this.rootPackages = new RootPackages();
        this.detectDuplicatePathsEnabled = true;
        this.preventCaching = true;
        this.pathMacroClass = RegExpPathMacros.class;
        this.pathMacroSeparators = new String[]{"{", ":", "}"};
        this.resultPathPrefix = null;
    }

    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }

    public void setActionConfig(ActionConfig actionConfig) {
        Objects.requireNonNull(actionConfig);
        this.actionConfig = actionConfig;
    }

    public void setActionAnnotations(Class<? extends Annotation> ... annotationsClasses) {
        for (Class<? extends Annotation> annotation : annotationsClasses) {
            ActionConfiguredBy actionConfiguredBy = annotation.getAnnotation(ActionConfiguredBy.class);
            if (actionConfiguredBy != null) {
                ActionConfig newActionConfig;
                Class<? extends ActionConfig> actionConfigClass = actionConfiguredBy.value();
                try {
                    Constructor<? extends ActionConfig> ctor = actionConfigClass.getDeclaredConstructor(ActionConfig.class);
                    newActionConfig = ctor.newInstance(this.actionConfig);
                }
                catch (Exception ex) {
                    throw new MadvocException("Invalid action configuration: " + actionConfigClass.getSimpleName(), ex);
                }
                this.annotations.put(annotation, newActionConfig);
            }
            this.actionAnnotations = ArraysUtil.append(this.actionAnnotations, annotation);
            this.actionAnnotationInstances = ArraysUtil.append(this.actionAnnotationInstances, new ActionAnnotation<Annotation>(annotation));
        }
    }

    public Class<? extends Annotation>[] getActionAnnotations() {
        return this.actionAnnotations;
    }

    public ActionAnnotation<?>[] getActionAnnotationInstances() {
        return this.actionAnnotationInstances;
    }

    public ActionConfig lookupActionConfig(Class<? extends Annotation> annotationType) {
        return this.annotations.getOrDefault(annotationType, this.actionConfig);
    }

    public ActionConfig lookupActionConfig(ActionAnnotationData actionAnnotationData) {
        if (actionAnnotationData == null) {
            return this.actionConfig;
        }
        return this.annotations.getOrDefault(actionAnnotationData.annotation().annotationType(), this.actionConfig);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        Objects.requireNonNull(encoding);
        this.encoding = encoding;
    }

    public boolean isApplyCharacterEncoding() {
        return this.applyCharacterEncoding;
    }

    public void setApplyCharacterEncoding(boolean applyCharacterEncoding) {
        this.applyCharacterEncoding = applyCharacterEncoding;
    }

    public FileUploadFactory getFileUploadFactory() {
        return this.fileUploadFactory;
    }

    public void setFileUploadFactory(FileUploadFactory fileUploadFactory) {
        this.fileUploadFactory = fileUploadFactory;
    }

    public RootPackages getRootPackages() {
        return this.rootPackages;
    }

    public boolean isDetectDuplicatePathsEnabled() {
        return this.detectDuplicatePathsEnabled;
    }

    public void setDetectDuplicatePathsEnabled(boolean detectDuplicatePathsEnabled) {
        this.detectDuplicatePathsEnabled = detectDuplicatePathsEnabled;
    }

    public boolean isPreventCaching() {
        return this.preventCaching;
    }

    public void setPreventCaching(boolean preventCaching) {
        this.preventCaching = preventCaching;
    }

    public String getResultPathPrefix() {
        return this.resultPathPrefix;
    }

    public void setResultPathPrefix(String resultPathPrefix) {
        this.resultPathPrefix = resultPathPrefix;
    }

    public Class<? extends PathMacros> getPathMacroClass() {
        return this.pathMacroClass;
    }

    public void setPathMacroClass(Class<? extends PathMacros> pathMacroClass) {
        this.pathMacroClass = pathMacroClass;
    }

    public String[] getPathMacroSeparators() {
        return this.pathMacroSeparators;
    }

    public void setPathMacroSeparators(String ... pathMacroSeparators) {
        this.pathMacroSeparators = pathMacroSeparators;
    }

    public String toString() {
        return "MadvocConfig{\n\tactionAnnotations=" + (this.actionAnnotations == null ? null : MadvocConfig.toString(this.actionAnnotations)) + ",\n\tapplyCharacterEncoding=" + this.applyCharacterEncoding + ",\n\tdetectDuplicatePathsEnabled=" + this.detectDuplicatePathsEnabled + ",\n\tencoding='" + this.encoding + '\'' + ",\n\tfileUploadFactory=" + this.fileUploadFactory + ",\n\tpathMacroClass=" + this.pathMacroClass.getName() + ",\n\tpreventCaching=" + this.preventCaching + ",\n\trootPackages=" + this.rootPackages + "\n}";
    }

    private static String toString(Class[] classes) {
        StringBuilder s = new StringBuilder();
        for (Class clazz : classes) {
            s.append("\n\t\t").append(clazz.getName());
        }
        return s.toString();
    }
}

