/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionHandler;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.component.ActionMethodParser;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocComponentLifecycle;
import jodd.madvoc.config.ActionDefinition;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.util.ArraysUtil;

public abstract class MadvocRouter
implements MadvocComponentLifecycle.Start {
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected ActionMethodParser actionMethodParser;
    @PetiteInject
    protected FiltersManager filtersManager;
    @PetiteInject
    protected InterceptorsManager interceptorsManager;

    public static MadvocRouter create() {
        return new MadvocRouter(){

            @Override
            public void start() {
            }
        };
    }

    public <T extends ActionInterceptor> MadvocRouter interceptor(Class<T> actionInterceptorClass) {
        this.interceptorsManager.resolve(actionInterceptorClass);
        return this;
    }

    public <T extends ActionInterceptor> MadvocRouter interceptor(Class<T> actionInterceptorClass, Consumer<T> interceptorConsumer) {
        ActionInterceptor interceptor = (ActionInterceptor)this.interceptorsManager.resolve(actionInterceptorClass);
        interceptorConsumer.accept(interceptor);
        return this;
    }

    public <T extends ActionFilter> MadvocRouter filter(Class<T> actionFilterClass) {
        this.filtersManager.resolve(actionFilterClass);
        return this;
    }

    public <T extends ActionFilter> MadvocRouter filter(Class<T> actionFilterClass, Consumer<T> filterConsumer) {
        ActionFilter filter = (ActionFilter)this.filtersManager.resolve(actionFilterClass);
        filterConsumer.accept(filter);
        return this;
    }

    public ActionBuilder route() {
        return new ActionBuilder();
    }

    public ActionBuilder get(String path) {
        return new ActionBuilder().path(path).httpMethod("GET");
    }

    public ActionBuilder post(String path) {
        return new ActionBuilder().path(path).httpMethod("POST");
    }

    public ActionBuilder put(String path) {
        return new ActionBuilder().path(path).httpMethod("PUT");
    }

    public ActionBuilder delete(String path) {
        return new ActionBuilder().path(path).httpMethod("DELETE");
    }

    public ActionBuilder options(String path) {
        return new ActionBuilder().path(path).httpMethod("OPTIONS");
    }

    public class ActionBuilder {
        ActionHandler actionHandler;
        String method;
        String actionPath;
        Class actionClass;
        Class<? extends ActionResult> actionResult;
        Method actionClassMethod;
        String actionMethodString;
        String alias;
        String resultBasePath;
        Class<? extends ActionFilter>[] actionFilters;
        Class<? extends ActionInterceptor>[] actionInterceptors;
        boolean async;

        public ActionBuilder path(String path) {
            this.actionPath = path;
            return this;
        }

        public ActionBuilder httpMethod(String method) {
            this.method = method;
            return this;
        }

        public ActionBuilder path(String method, String path) {
            this.method = method;
            return this.path(path);
        }

        public ActionBuilder mapTo(Class actionClass, Method actionMethod) {
            this.actionClass = actionClass;
            this.actionClassMethod = actionMethod;
            this.actionMethodString = null;
            return this;
        }

        public ActionBuilder mapTo(Method actionMethod) {
            this.actionClass = actionMethod.getDeclaringClass();
            this.actionClassMethod = actionMethod;
            this.actionMethodString = null;
            return this;
        }

        public ActionBuilder mapTo(Class actionClass, String actionMethodName) {
            this.actionClass = actionClass;
            this.actionClassMethod = null;
            this.actionMethodString = actionMethodName;
            return this;
        }

        public ActionBuilder mapTo(ActionHandler actionHandler) {
            this.actionHandler = actionHandler;
            return this;
        }

        public ActionBuilder interceptBy(Class<? extends ActionInterceptor> ... interceptors) {
            this.actionInterceptors = this.actionInterceptors == null ? interceptors : ArraysUtil.join(this.actionInterceptors, interceptors);
            return this;
        }

        public ActionBuilder interceptBy(Class<? extends ActionInterceptor> interceptor) {
            this.actionInterceptors = this.actionInterceptors == null ? new Class[]{interceptor} : ArraysUtil.append(this.actionInterceptors, interceptor);
            return this;
        }

        public ActionBuilder filterBy(Class<? extends ActionFilter> ... filters) {
            this.actionFilters = this.actionFilters == null ? filters : ArraysUtil.join(this.actionFilters, filters);
            return this;
        }

        public ActionBuilder filterBy(Class<? extends ActionFilter> filter) {
            this.actionFilters = this.actionFilters == null ? new Class[]{filter} : ArraysUtil.append(this.actionFilters, filter);
            return this;
        }

        public ActionBuilder alias(String aliasPath) {
            this.alias = aliasPath;
            return this;
        }

        public ActionBuilder renderWith(Class<? extends ActionResult> actionResult) {
            this.actionResult = actionResult;
            return this;
        }

        public ActionBuilder async(boolean async) {
            this.async = async;
            return this;
        }

        public ActionBuilder resultBase(String resultBasePath) {
            this.resultBasePath = resultBasePath;
            return this;
        }

        public MadvocRouter bind() {
            ActionConfig actionConfig = MadvocRouter.this.madvocConfig.getActionConfig();
            if (this.actionMethodString != null) {
                this.actionClassMethod = MadvocRouter.this.actionsManager.resolveActionMethod(this.actionClass, this.actionMethodString);
            }
            ActionFilter[] actionFilterInstances = (ActionFilter[])MadvocRouter.this.filtersManager.resolveAll(actionConfig, this.actionFilters);
            ActionInterceptor[] actionInterceptorInstances = (ActionInterceptor[])MadvocRouter.this.interceptorsManager.resolveAll(actionConfig, this.actionInterceptors);
            ActionDefinition actionDefinition = this.resultBasePath != null ? new ActionDefinition(this.actionPath, this.method, this.resultBasePath) : new ActionDefinition(this.actionPath, this.method);
            ActionRuntime actionRuntime = MadvocRouter.this.actionMethodParser.createActionRuntime(this.actionHandler, this.actionClass, this.actionClassMethod, this.actionResult, actionFilterInstances, actionInterceptorInstances, actionDefinition, this.async, actionConfig);
            MadvocRouter.this.actionsManager.registerActionRuntime(actionRuntime);
            if (this.alias != null) {
                MadvocRouter.this.actionsManager.registerPathAlias(this.alias, this.actionPath);
            }
            return MadvocRouter.this;
        }

        public boolean isSet() {
            return this.actionPath != null && this.actionMethodString != null;
        }
    }
}

