/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.crypt;

import jodd.util.buffer.FastByteBuffer;

public abstract class BlockCipher {
    protected static final byte TERMINATOR = -1;
    protected final int blockSizeInBytes;

    protected BlockCipher(int blockSize) {
        this.blockSizeInBytes = blockSize >> 3;
    }

    protected abstract byte[] encryptBlock(byte[] var1, int var2);

    protected abstract byte[] decryptBlock(byte[] var1, int var2);

    public byte[] encrypt(byte[] content) {
        byte[] encrypted;
        FastByteBuffer fbb = new FastByteBuffer();
        int length = content.length + 1;
        int blockCount = length / this.blockSizeInBytes;
        int remaining = length;
        int offset = 0;
        for (int i = 0; i < blockCount && remaining != this.blockSizeInBytes; remaining -= this.blockSizeInBytes, ++i) {
            encrypted = this.encryptBlock(content, offset);
            fbb.append(encrypted);
            offset += this.blockSizeInBytes;
        }
        if (remaining != 0) {
            byte[] block = new byte[this.blockSizeInBytes];
            System.arraycopy(content, offset, block, 0, remaining - 1);
            block[remaining - 1] = -1;
            encrypted = this.encryptBlock(block, 0);
            fbb.append(encrypted);
        }
        return fbb.toArray();
    }

    public byte[] decrypt(byte[] encryptedContent) {
        int ndx;
        FastByteBuffer fbb = new FastByteBuffer();
        int length = encryptedContent.length;
        int blockCount = length / this.blockSizeInBytes;
        int offset = 0;
        for (int i = 0; i < blockCount - 1; ++i) {
            byte[] decrypted = this.decryptBlock(encryptedContent, offset);
            fbb.append(decrypted);
            offset += this.blockSizeInBytes;
        }
        byte[] decrypted = this.decryptBlock(encryptedContent, offset);
        for (ndx = this.blockSizeInBytes - 1; ndx >= 0 && decrypted[ndx] != -1; --ndx) {
        }
        fbb.append(decrypted, 0, ndx);
        return fbb.toArray();
    }
}

