/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.crypt;

import jodd.util.crypt.BCrypt;
import jodd.util.crypt.PBKDF2Hash;

public interface HashEngine {
    public static HashEngine bcrypt(int rounds) {
        return HashEngine.bcrypt(BCrypt.gensalt(rounds));
    }

    public static HashEngine bcrypt(final String salt) {
        return new HashEngine(){

            @Override
            public String hash(String input) {
                return BCrypt.hashpw(input, salt);
            }

            @Override
            public boolean check(String input, String hash) {
                return BCrypt.checkpw(input, hash);
            }
        };
    }

    public static HashEngine pbk2() {
        final PBKDF2Hash pbkdf2Hash = new PBKDF2Hash();
        return new HashEngine(){

            @Override
            public String hash(String input) {
                return pbkdf2Hash.createHash(input);
            }

            @Override
            public boolean check(String input, String hash) {
                return pbkdf2Hash.validatePassword(input, hash);
            }
        };
    }

    public String hash(String var1);

    public boolean check(String var1, String var2);
}

