/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.lang.reflect.Modifier;
import jodd.bean.JoddBean;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.Getter;
import jodd.introspector.PropertyDescriptor;
import jodd.json.JsonContext;
import jodd.json.Path;
import jodd.json.meta.JsonAnnotationManager;

public abstract class TypeJsonVisitor {
    protected final JsonContext jsonContext;
    protected final boolean declared;
    protected final String classMetadataName;
    protected final Class type;
    protected int count;
    protected final JsonAnnotationManager.TypeData typeData;

    public TypeJsonVisitor(JsonContext jsonContext, Class type) {
        this.jsonContext = jsonContext;
        this.count = 0;
        this.declared = false;
        this.classMetadataName = jsonContext.jsonSerializer.classMetadataName;
        this.type = type;
        this.typeData = JsonAnnotationManager.get().lookupTypeData(type);
    }

    public void visit() {
        PropertyDescriptor[] propertyDescriptors;
        ClassDescriptor classDescriptor = JoddBean.defaults().getClassIntrospector().lookup(this.type);
        if (this.classMetadataName != null) {
            this.onProperty(this.classMetadataName, null, false);
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = classDescriptor.getAllPropertyDescriptors()) {
            Getter getter = propertyDescriptor.getGetter(this.declared);
            if (getter == null) continue;
            String propertyName = propertyDescriptor.getName();
            boolean isTransient = false;
            FieldDescriptor fieldDescriptor = propertyDescriptor.getFieldDescriptor();
            if (fieldDescriptor != null) {
                isTransient = Modifier.isTransient(fieldDescriptor.getField().getModifiers());
            }
            this.onProperty(propertyName, propertyDescriptor, isTransient);
        }
    }

    protected void onProperty(String propertyName, PropertyDescriptor propertyDescriptor, boolean isTransient) {
        boolean include;
        Class propertyType = propertyDescriptor == null ? null : propertyDescriptor.getType();
        Path currentPath = this.jsonContext.path;
        currentPath.push(propertyName);
        if (propertyType != null) {
            propertyName = this.typeData.resolveJsonName(propertyName);
        }
        boolean bl = include = !this.typeData.strict;
        if (isTransient) {
            include = false;
        }
        include = this.jsonContext.matchIgnoredPropertyTypes(propertyType, true, include);
        include = this.typeData.rules.apply(propertyName, true, include);
        if (!(include = this.jsonContext.matchPathToQueries(include))) {
            currentPath.pop();
            return;
        }
        this.onSerializableProperty(propertyName, propertyDescriptor);
        currentPath.pop();
    }

    protected abstract void onSerializableProperty(String var1, PropertyDescriptor var2);
}

