/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jodd.bean.JoddBean;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.madvoc.ScopeType;
import jodd.madvoc.config.ScopeData;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.Out;
import jodd.madvoc.meta.Scope;

public class ScopeDataResolver {
    public ScopeData[] resolveScopeData(Class type) {
        ScopeType[] allScopeTypes = ScopeType.values();
        ScopeData[] scopeData = new ScopeData[allScopeTypes.length];
        int count = 0;
        for (ScopeType scopeType : allScopeTypes) {
            ScopeData sd = this.inspectClassScopeData(type, scopeType);
            if (sd != null) {
                ++count;
            }
            scopeData[scopeType.value()] = sd;
        }
        if (count == 0) {
            return null;
        }
        return scopeData;
    }

    public ScopeData[] resolveScopeData(String name, Class type, Annotation[] annotations) {
        ScopeType[] allScopeTypes = ScopeType.values();
        ScopeData[] scopeData = new ScopeData[allScopeTypes.length];
        int count = 0;
        for (ScopeType scopeType : allScopeTypes) {
            ScopeData sd = this.inspectMethodParameterScopeData(name, type, annotations, scopeType);
            if (sd != null) {
                ++count;
            }
            scopeData[scopeType.value()] = sd;
        }
        if (count == 0) {
            return null;
        }
        return scopeData;
    }

    public Class<? extends Annotation> detectAnnotationType(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof In) {
                return annotation.annotationType();
            }
            if (!(annotation instanceof Out)) continue;
            return annotation.annotationType();
        }
        return null;
    }

    protected ScopeData inspectMethodParameterScopeData(String name, Class type, Annotation[] annotations, ScopeType scopeType) {
        ScopeData.Out scopeDataOut;
        ScopeData.In scopeDataIn;
        In in = null;
        Out out = null;
        Scope scope = null;
        for (Annotation annotation : annotations) {
            if (annotation instanceof In) {
                in = (In)annotation;
                continue;
            }
            if (annotation instanceof Out) {
                out = (Out)annotation;
                continue;
            }
            if (!(annotation instanceof Scope)) continue;
            scope = (Scope)annotation;
        }
        ScopeData sd = new ScopeData();
        int count = 0;
        if (in != null && (scopeDataIn = this.inspectIn(in, scope, scopeType, name, type)) != null) {
            ++count;
            sd.in = new ScopeData.In[]{scopeDataIn};
        }
        if (out != null && (scopeDataOut = this.inspectOut(out, scope, scopeType, name, type)) != null) {
            ++count;
            sd.out = new ScopeData.Out[]{scopeDataOut};
        }
        if (count == 0) {
            return null;
        }
        return sd;
    }

    protected void saveNameTarget(ScopeData.In ii, String value, String propertyName) {
        if ((value = value.trim()).length() > 0) {
            ii.name = value;
            ii.target = propertyName;
        } else {
            ii.name = propertyName;
            ii.target = null;
        }
    }

    protected void saveNameTarget(ScopeData.Out oi, String value, String propertyName) {
        if ((value = value.trim()).length() > 0) {
            oi.name = value;
            oi.target = propertyName;
        } else {
            oi.name = propertyName;
            oi.target = null;
        }
    }

    protected ScopeData.In inspectIn(In in, Scope scope, ScopeType matchingScopeType, String propertyName, Class propertyType) {
        if (in == null) {
            return null;
        }
        ScopeType inScope = ScopeType.defaultOrScopeType(scope);
        if (inScope != matchingScopeType) {
            return null;
        }
        ScopeData.In ii = new ScopeData.In();
        this.saveNameTarget(ii, in.value(), propertyName);
        ii.type = propertyType;
        return ii;
    }

    protected ScopeData.Out inspectOut(Out out, Scope scope, ScopeType matchingScopeType, String propertyName, Class propertyType) {
        if (out == null) {
            return null;
        }
        ScopeType outScope = ScopeType.defaultOrScopeType(scope);
        if (outScope != matchingScopeType) {
            return null;
        }
        ScopeData.Out oi = new ScopeData.Out();
        this.saveNameTarget(oi, out.value(), propertyName);
        oi.type = propertyType;
        return oi;
    }

    protected ScopeData inspectClassScopeData(Class actionClass, ScopeType scopeType) {
        ClassDescriptor cd = JoddBean.defaults().getClassIntrospector().lookup(actionClass);
        PropertyDescriptor[] allProperties = cd.getAllPropertyDescriptors();
        ArrayList<ScopeData.In> listIn = new ArrayList<ScopeData.In>(allProperties.length);
        ArrayList<ScopeData.Out> listOut = new ArrayList<ScopeData.Out>(allProperties.length);
        for (PropertyDescriptor pd : allProperties) {
            ScopeData.Out oi;
            ScopeData.In ii;
            Method method;
            Scope scope = null;
            In in = null;
            Out out = null;
            if (pd.getFieldDescriptor() != null) {
                Field field = pd.getFieldDescriptor().getField();
                in = field.getAnnotation(In.class);
                out = field.getAnnotation(Out.class);
                scope = field.getAnnotation(Scope.class);
            }
            if (pd.getWriteMethodDescriptor() != null) {
                method = pd.getWriteMethodDescriptor().getMethod();
                if (in == null) {
                    in = method.getAnnotation(In.class);
                }
                if (out == null) {
                    out = method.getAnnotation(Out.class);
                }
                if (scope == null) {
                    scope = method.getAnnotation(Scope.class);
                }
            }
            if (pd.getReadMethodDescriptor() != null) {
                method = pd.getReadMethodDescriptor().getMethod();
                if (in == null) {
                    in = method.getAnnotation(In.class);
                }
                if (out == null) {
                    out = method.getAnnotation(Out.class);
                }
                if (scope == null) {
                    scope = method.getAnnotation(Scope.class);
                }
            }
            if ((ii = this.inspectIn(in, scope, scopeType, pd.getName(), pd.getType())) != null) {
                listIn.add(ii);
            }
            if ((oi = this.inspectOut(out, scope, scopeType, pd.getName(), pd.getType())) == null) continue;
            listOut.add(oi);
        }
        if (listIn.isEmpty() && listOut.isEmpty()) {
            return null;
        }
        ScopeData scopeData = new ScopeData();
        if (!listIn.isEmpty()) {
            scopeData.in = listIn.toArray(new ScopeData.In[listIn.size()]);
        }
        if (!listOut.isEmpty()) {
            scopeData.out = listOut.toArray(new ScopeData.Out[listOut.size()]);
        }
        return scopeData;
    }
}

