/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.List;
import jodd.asm.AnnotationVisitorAdapter;
import jodd.asm.EmptyClassVisitor;
import jodd.asm.EmptyMethodVisitor;
import jodd.asm6.AnnotationVisitor;
import jodd.asm6.MethodVisitor;
import jodd.proxetta.JoddProxetta;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxyTarget;
import jodd.proxetta.ProxyTargetReplacement;
import jodd.proxetta.asm.HistoryMethodAdapter;
import jodd.proxetta.asm.MethodSignatureVisitor;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.proxetta.asm.ProxyAspectData;
import jodd.proxetta.asm.TargetMethodData;
import jodd.proxetta.asm.WorkData;

public class ProxettaMethodBuilder
extends EmptyMethodVisitor {
    public static final String TARGET_CLASS_NAME = ProxyTarget.class.getSimpleName();
    protected final MethodSignatureVisitor msign;
    protected final WorkData wd;
    protected final List<ProxyAspectData> aspectList;
    protected TargetMethodData tmd;
    protected MethodVisitor methodVisitor;
    protected boolean proxyInfoRequested;

    public ProxettaMethodBuilder(MethodSignatureVisitor msign, WorkData wd, List<ProxyAspectData> aspectList) {
        this.msign = msign;
        this.wd = wd;
        this.aspectList = aspectList;
        this.createFirstChainDelegate_Start();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor destAnn = this.methodVisitor.visitAnnotation(desc, visible);
        return new AnnotationVisitorAdapter(destAnn);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor destAnn = this.methodVisitor.visitAnnotationDefault();
        return new AnnotationVisitorAdapter(destAnn);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationVisitor destAnn = this.methodVisitor.visitParameterAnnotation(parameter, desc, visible);
        return new AnnotationVisitorAdapter(destAnn);
    }

    @Override
    public void visitEnd() {
        this.createFirstChainDelegate_Continue(this.tmd);
        for (int p = 0; p < this.tmd.proxyData.length; ++p) {
            this.tmd.selectCurrentProxy(p);
            this.createProxyMethod(this.tmd);
        }
    }

    protected void createFirstChainDelegate_Start() {
        int access = this.msign.getAccessFlags();
        if ((access & 0x10) != 0) {
            throw new ProxettaException("Unable to create proxy for final method: " + this.msign + ". Remove final modifier or change the pointcut definition.");
        }
        this.tmd = new TargetMethodData(this.msign, this.aspectList);
        access &= 0xFFFFFEFF;
        this.methodVisitor = this.wd.dest.visitMethod(access &= 0xFFFFFBFF, this.tmd.msign.getMethodName(), this.tmd.msign.getDescription(), this.tmd.msign.getAsmMethodSignature(), null);
    }

    protected void createFirstChainDelegate_Continue(TargetMethodData tmd) {
        this.methodVisitor.visitCode();
        if (tmd.msign.isStatic) {
            ProxettaAsmUtil.loadStaticMethodArguments(this.methodVisitor, tmd.msign);
            this.methodVisitor.visitMethodInsn(184, this.wd.thisReference, tmd.firstMethodName(), tmd.msign.getDescription(), false);
        } else {
            ProxettaAsmUtil.loadSpecialMethodArguments(this.methodVisitor, tmd.msign);
            this.methodVisitor.visitMethodInsn(183, this.wd.thisReference, tmd.firstMethodName(), tmd.msign.getDescription(), false);
        }
        ProxettaAsmUtil.visitReturn(this.methodVisitor, tmd.msign, false);
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    public void createProxyMethod(final TargetMethodData td) {
        final ProxyAspectData aspectData = td.getProxyData();
        int access = td.msign.getAccessFlags();
        access &= 0xFFFFFEFF;
        access &= 0xFFFFFBFF;
        access = ProxettaAsmUtil.makePrivateFinalAccess(access);
        final MethodVisitor mv = this.wd.dest.visitMethod(access, td.methodName(), td.msign.getDescription(), null, null);
        mv.visitCode();
        aspectData.getAdviceClassReader().accept(new EmptyClassVisitor(){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (!name.equals(JoddProxetta.defaults().getExecuteMethodName())) {
                    return null;
                }
                return new HistoryMethodAdapter(mv){

                    @Override
                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if (owner.equals(aspectData.adviceReference)) {
                            owner = ProxettaMethodBuilder.this.wd.thisReference;
                            name = ProxettaAsmUtil.adviceFieldName(name, aspectData.aspectIndex);
                        }
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }

                    @Override
                    public void visitVarInsn(int opcode, int var) {
                        var += var == 0 ? 0 : td.msign.getAllArgumentsSize();
                        if (ProxettaMethodBuilder.this.proxyInfoRequested) {
                            ProxettaMethodBuilder.this.proxyInfoRequested = false;
                            if (opcode == 58) {
                                ProxyTargetReplacement.info(this.mv, td.msign, var);
                            }
                        }
                        super.visitVarInsn(opcode, var);
                    }

                    @Override
                    public void visitIincInsn(int var, int increment) {
                        super.visitIincInsn(var += var == 0 ? 0 : td.msign.getAllArgumentsSize(), increment);
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        if (opcode == 176) {
                            ProxettaAsmUtil.visitReturn(this.mv, td.msign, true);
                            return;
                        }
                        if (this.traceNext && (opcode == 87 || opcode == 88)) {
                            return;
                        }
                        super.visitInsn(opcode);
                    }

                    @Override
                    public void visitMethodInsn(int opcode, String string, String mname, String mdesc, boolean isInterface) {
                        if (opcode == 182 || opcode == 185 || opcode == 183) {
                            if (string.equals(aspectData.adviceReference)) {
                                string = ProxettaMethodBuilder.this.wd.thisReference;
                                mname = ProxettaAsmUtil.adviceMethodName(mname, aspectData.aspectIndex);
                            }
                        } else if (opcode == 184) {
                            if (string.equals(aspectData.adviceReference)) {
                                string = ProxettaMethodBuilder.this.wd.thisReference;
                                mname = ProxettaAsmUtil.adviceMethodName(mname, aspectData.aspectIndex);
                            } else if (string.endsWith('/' + TARGET_CLASS_NAME)) {
                                if (ProxettaAsmUtil.isInvokeMethod(mname, mdesc)) {
                                    if (td.isLastMethodInChain()) {
                                        if (!ProxettaMethodBuilder.this.wd.isWrapper()) {
                                            ProxettaAsmUtil.loadSpecialMethodArguments(this.mv, td.msign);
                                            this.mv.visitMethodInsn(183, ProxettaMethodBuilder.this.wd.superReference, td.msign.getMethodName(), td.msign.getDescription(), isInterface);
                                        } else {
                                            this.mv.visitVarInsn(25, 0);
                                            this.mv.visitFieldInsn(180, ProxettaMethodBuilder.this.wd.thisReference, ProxettaMethodBuilder.this.wd.wrapperRef, ProxettaMethodBuilder.this.wd.wrapperType);
                                            ProxettaAsmUtil.loadVirtualMethodArguments(this.mv, td.msign);
                                            if (ProxettaMethodBuilder.this.wd.wrapInterface) {
                                                this.mv.visitMethodInsn(185, ProxettaMethodBuilder.this.wd.wrapperType.substring(1, ProxettaMethodBuilder.this.wd.wrapperType.length() - 1), td.msign.getMethodName(), td.msign.getDescription(), true);
                                            } else {
                                                this.mv.visitMethodInsn(182, ProxettaMethodBuilder.this.wd.wrapperType.substring(1, ProxettaMethodBuilder.this.wd.wrapperType.length() - 1), td.msign.getMethodName(), td.msign.getDescription(), isInterface);
                                            }
                                        }
                                        ProxettaAsmUtil.prepareReturnValue(this.mv, td.msign, aspectData.maxLocalVarOffset);
                                        this.traceNext = true;
                                    } else {
                                        ProxettaAsmUtil.loadSpecialMethodArguments(this.mv, td.msign);
                                        this.mv.visitMethodInsn(183, ProxettaMethodBuilder.this.wd.thisReference, td.nextMethodName(), td.msign.getDescription(), isInterface);
                                        ProxettaAsmUtil.visitReturn(this.mv, td.msign, false);
                                    }
                                    return;
                                }
                                if (ProxettaAsmUtil.isArgumentsCountMethod(mname, mdesc)) {
                                    ProxyTargetReplacement.argumentsCount(this.mv, td.msign);
                                    return;
                                }
                                if (ProxettaAsmUtil.isArgumentTypeMethod(mname, mdesc)) {
                                    int argIndex = this.getArgumentIndex();
                                    ProxyTargetReplacement.argumentType(this.mv, td.msign, argIndex);
                                    return;
                                }
                                if (ProxettaAsmUtil.isArgumentMethod(mname, mdesc)) {
                                    int argIndex = this.getArgumentIndex();
                                    ProxyTargetReplacement.argument(this.mv, td.msign, argIndex);
                                    return;
                                }
                                if (ProxettaAsmUtil.isSetArgumentMethod(mname, mdesc)) {
                                    int argIndex = this.getArgumentIndex();
                                    ProxettaAsmUtil.checkArgumentIndex(td.msign, argIndex);
                                    this.mv.visitInsn(87);
                                    ProxettaAsmUtil.storeMethodArgumentFromObject(this.mv, td.msign, argIndex);
                                    return;
                                }
                                if (ProxettaAsmUtil.isCreateArgumentsArrayMethod(mname, mdesc)) {
                                    ProxyTargetReplacement.createArgumentsArray(this.mv, td.msign);
                                    return;
                                }
                                if (ProxettaAsmUtil.isCreateArgumentsClassArrayMethod(mname, mdesc)) {
                                    ProxyTargetReplacement.createArgumentsClassArray(this.mv, td.msign);
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetMethod(mname, mdesc)) {
                                    this.mv.visitVarInsn(25, 0);
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetClassMethod(mname, mdesc)) {
                                    ProxyTargetReplacement.targetClass(this.mv, td.msign);
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetMethodNameMethod(mname, mdesc)) {
                                    ProxyTargetReplacement.targetMethodName(this.mv, td.msign);
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetMethodSignatureMethod(mname, mdesc)) {
                                    ProxyTargetReplacement.targetMethodSignature(this.mv, td.msign);
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetMethodDescriptionMethod(mname, mdesc)) {
                                    ProxyTargetReplacement.targetMethodDescription(this.mv, td.msign);
                                    return;
                                }
                                if (ProxettaAsmUtil.isInfoMethod(mname, mdesc)) {
                                    ProxettaMethodBuilder.this.proxyInfoRequested = true;
                                    return;
                                }
                                if (ProxettaAsmUtil.isReturnTypeMethod(mname, mdesc)) {
                                    ProxyTargetReplacement.returnType(this.mv, td.msign);
                                    return;
                                }
                                if (ProxettaAsmUtil.isReturnValueMethod(mname, mdesc)) {
                                    ProxettaAsmUtil.castToReturnType(this.mv, td.msign);
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetMethodAnnotationMethod(mname, mdesc)) {
                                    String[] args = this.getLastTwoStringArguments();
                                    this.mv.visitInsn(87);
                                    this.mv.visitInsn(87);
                                    ProxyTargetReplacement.targetMethodAnnotation(this.mv, td.msign, args);
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetClassAnnotationMethod(mname, mdesc)) {
                                    String[] args = this.getLastTwoStringArguments();
                                    this.mv.visitInsn(87);
                                    this.mv.visitInsn(87);
                                    ProxyTargetReplacement.targetClassAnnotation(this.mv, td.msign.getClassInfo(), args);
                                    return;
                                }
                            }
                        }
                        super.visitMethodInsn(opcode, string, mname, mdesc, isInterface);
                    }
                };
            }
        }, 0);
    }
}

