/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.debug;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jodd.db.DbSqlException;
import jodd.db.debug.LoggableAdvice;
import jodd.proxetta.Proxetta;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.proxetta.impl.WrapperProxetta;
import jodd.proxetta.impl.WrapperProxettaFactory;
import jodd.util.ClassUtil;

public abstract class BaseLoggableFactory<T> {
    protected Class<T> wrappedStatement;
    protected WrapperProxettaFactory builder;
    protected Field sqlTemplateField;
    protected Method getQueryStringMethod;
    protected final WrapperProxetta proxetta;
    protected final Class<T> targetClass;

    protected BaseLoggableFactory(Class<T> targetClass) {
        this.targetClass = targetClass;
        this.proxetta = (WrapperProxetta)Proxetta.wrapperProxetta().withAspect(ProxyAspect.of(LoggableAdvice.class, methodInfo -> {
            int argumentsCount = methodInfo.getArgumentsCount();
            char argumentType = '\u0000';
            if (argumentsCount >= 1) {
                argumentType = methodInfo.getArgument(1).getOpcode();
            }
            return methodInfo.getReturnType().getOpcode() == 'V' && argumentType == 'I' && methodInfo.isPublicMethod() && methodInfo.getMethodName().startsWith("set") && (argumentsCount == 2 || argumentsCount == 3);
        }));
    }

    protected T wrap(T preparedStatement, String sql) {
        T wrapper;
        if (this.wrappedStatement == null) {
            this.builder = this.proxetta.proxy();
            this.builder.setTarget(this.targetClass);
            this.builder.setTargetProxyClassName(this.getClass().getPackage().getName() + '.' + this.targetClass.getSimpleName());
            this.wrappedStatement = this.builder.define();
            try {
                String fieldName = ProxettaAsmUtil.adviceFieldName("sqlTemplate", 0);
                this.sqlTemplateField = this.wrappedStatement.getField(fieldName);
                String methodName = ProxettaAsmUtil.adviceMethodName("getQueryString", 0);
                this.getQueryStringMethod = this.wrappedStatement.getMethod(methodName, new Class[0]);
            }
            catch (Exception ex) {
                throw new DbSqlException(ex);
            }
        }
        try {
            wrapper = ClassUtil.newInstance(this.wrappedStatement);
        }
        catch (Exception ex) {
            throw new DbSqlException(ex);
        }
        this.builder.injectTargetIntoWrapper(preparedStatement, wrapper);
        try {
            this.sqlTemplateField.set(wrapper, sql);
        }
        catch (Exception ex) {
            throw new DbSqlException(ex);
        }
        return wrapper;
    }

    public String getQueryString(T statement) {
        try {
            return (String)this.getQueryStringMethod.invoke(statement, new Object[0]);
        }
        catch (Exception ex) {
            throw new DbSqlException(ex);
        }
    }
}

