/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import jodd.db.type.SqlType;
import jodd.time.TimeUtil;

public class LocalDateSqlType
extends SqlType<LocalDate> {
    @Override
    public void set(PreparedStatement st, int index, LocalDate value, int dbSqlType) throws SQLException {
        if (value == null) {
            st.setNull(index, dbSqlType);
            return;
        }
        if (dbSqlType == 93) {
            st.setTimestamp(index, new Timestamp(TimeUtil.toMilliseconds(value)));
            return;
        }
        if (dbSqlType == 12) {
            st.setString(index, value.toString());
            return;
        }
        st.setLong(index, TimeUtil.toMilliseconds(value));
    }

    @Override
    public LocalDate get(ResultSet rs, int index, int dbSqlType) throws SQLException {
        if (dbSqlType == 93) {
            Timestamp timestamp = rs.getTimestamp(index);
            if (timestamp == null) {
                return null;
            }
            return TimeUtil.fromMilliseconds(timestamp.getTime()).toLocalDate();
        }
        if (dbSqlType == 12) {
            String string = rs.getString(index);
            if (string == null) {
                return null;
            }
            return LocalDate.parse(string);
        }
        long time = rs.getLong(index);
        if (time == 0L && rs.wasNull()) {
            return null;
        }
        return TimeUtil.fromMilliseconds(time).toLocalDate();
    }
}

