/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import jodd.time.TimeUtil;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;

public class LocalDateConverter
implements TypeConverter<LocalDate> {
    @Override
    public LocalDate convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        if (value instanceof Calendar) {
            return TimeUtil.fromCalendar((Calendar)value).toLocalDate();
        }
        if (value instanceof Timestamp) {
            return TimeUtil.fromMilliseconds(((Timestamp)value).getTime()).toLocalDate();
        }
        if (value instanceof Date) {
            return TimeUtil.fromDate((Date)value).toLocalDate();
        }
        if (value instanceof Number) {
            return TimeUtil.fromMilliseconds(((Number)value).longValue()).toLocalDate();
        }
        if (value instanceof LocalTime) {
            throw new TypeConversionException("Can't convert to date just from time: " + value);
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            return LocalDate.parse(stringValue);
        }
        try {
            return TimeUtil.fromMilliseconds(Long.parseLong(stringValue)).toLocalDate();
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

