/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.collection;

import java.util.Map;
import jodd.util.collection.UnmodifiableMapEntry;

public class MapEntry<K, V>
implements Map.Entry<K, V> {
    private K key;
    private V value;

    public static <T, R> MapEntry<T, R> create(T key, R value) {
        return new MapEntry<T, R>(key, value);
    }

    public static <T, R> MapEntry<T, R> createUnmodifiable(T key, R value) {
        return new UnmodifiableMapEntry<T, R>(key, value);
    }

    public MapEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        this.value = value;
        return this.value;
    }

    public K setKey(K key) {
        this.key = key;
        return this.key;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)obj;
        return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
    }

    @Override
    public int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }
}

