/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.scope;

import javax.servlet.AsyncContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.Targets;
import jodd.madvoc.scope.MadvocScope;

public class InstancesInjector {
    private final MadvocScope madvocScope;

    public InstancesInjector(MadvocScope bindedScope) {
        this.madvocScope = bindedScope;
    }

    public void inject(ActionRequest actionRequest, Targets targets) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        targets.forEachTargetAndIn(this.madvocScope, (target, in) -> {
            Class inType = in.type();
            Object value = null;
            if (inType == HttpServletRequest.class) {
                value = servletRequest;
            } else if (inType == ServletRequest.class) {
                value = servletRequest;
            } else if (inType == HttpServletResponse.class) {
                value = servletResponse;
            } else if (inType == ServletResponse.class) {
                value = servletResponse;
            } else if (inType == HttpSession.class) {
                value = servletRequest.getSession();
            } else if (inType == ServletContext.class) {
                value = servletRequest.getServletContext();
            } else if (inType == AsyncContext.class) {
                value = servletRequest.getAsyncContext();
            } else if (inType == ActionRequest.class) {
                value = actionRequest;
            }
            if (value != null) {
                target.writeValue((InjectionPoint)in, value, true);
            }
        });
    }

    public void inject(ServletContext servletContext, Targets targets) {
        targets.forEachTargetAndIn(this.madvocScope, (target, in) -> {
            Class inType = in.type();
            ServletContext value = null;
            if (inType == ServletContext.class) {
                value = servletContext;
            }
            if (value != null) {
                target.writeValue((InjectionPoint)in, (Object)value, true);
            }
        });
    }

    public boolean isUnusedType(Class inType) {
        if (inType == HttpServletRequest.class) {
            return false;
        }
        if (inType == ServletRequest.class) {
            return false;
        }
        if (inType == HttpServletResponse.class) {
            return false;
        }
        if (inType == ServletResponse.class) {
            return false;
        }
        if (inType == HttpSession.class) {
            return false;
        }
        if (inType == ServletContext.class) {
            return false;
        }
        if (inType == AsyncContext.class) {
            return false;
        }
        if (inType == ActionRequest.class) {
            return false;
        }
        return false;
    }
}

