/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.HashSet;
import java.util.Set;
import jodd.cache.TypeCache;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.meta.RenderWith;
import jodd.madvoc.result.ActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.util.ClassUtil;

public class ResultsManager {
    private static final Logger log = LoggerFactory.getLogger(ResultsManager.class);
    @PetiteInject
    protected ContextInjectorComponent contextInjectorComponent;
    protected final TypeCache<ActionResult> allResults = TypeCache.createDefault();

    public Set<ActionResult> getAllActionResults() {
        HashSet<ActionResult> set = new HashSet<ActionResult>(this.allResults.size());
        this.allResults.forEachValue(set::add);
        return set;
    }

    public ActionResult register(Class<? extends ActionResult> resultClass) {
        return this.register(this.createResult(resultClass));
    }

    protected ActionResult register(ActionResult result) {
        Class<?> actionResultClass = result.getClass();
        ActionResult existingResult = this.allResults.get(actionResultClass);
        if (existingResult != null) {
            if (log.isDebugEnabled()) {
                log.debug("ActionResult already registered: " + actionResultClass);
            }
            return existingResult;
        }
        this.allResults.put(actionResultClass, result);
        this.initializeResult(result);
        return result;
    }

    private ActionResult lookupAndRegisterIfMissing(Class<? extends ActionResult> actionResultClass) {
        ActionResult actionResult = this.allResults.get(actionResultClass);
        if (actionResult == null) {
            actionResult = this.register(actionResultClass);
        }
        return actionResult;
    }

    public ActionResult lookup(ActionRequest actionRequest, Object resultObject) {
        ActionResult actionResultHandler = null;
        ActionRuntime actionRuntime = actionRequest.getActionRuntime();
        Class<? extends ActionResult> actionResultClass = actionRuntime.getActionResult();
        if (actionResultClass != null) {
            actionResultHandler = this.lookupAndRegisterIfMissing(actionResultClass);
        }
        if (actionResultHandler == null && resultObject != null) {
            RenderWith renderWith = resultObject.getClass().getAnnotation(RenderWith.class);
            if (renderWith != null) {
                actionResultHandler = this.lookupAndRegisterIfMissing(renderWith.value());
            } else if (resultObject instanceof ActionResult) {
                actionResultHandler = (ActionResult)resultObject;
            }
        }
        if (actionResultHandler == null && (actionResultClass = (actionRuntime = actionRequest.getActionRuntime()).getDefaultActionResult()) != null) {
            actionResultHandler = this.lookupAndRegisterIfMissing(actionResultClass);
        }
        if (actionResultHandler == null) {
            throw new MadvocException("ActionResult not found for: " + resultObject);
        }
        actionRequest.bindActionResult(resultObject);
        return actionResultHandler;
    }

    protected void initializeResult(ActionResult result) {
        this.contextInjectorComponent.injectContext(result);
    }

    protected ActionResult createResult(Class<? extends ActionResult> actionResultClass) {
        try {
            return ClassUtil.newInstance(actionResultClass);
        }
        catch (Exception ex) {
            throw new MadvocException("Invalid Madvoc result: " + actionResultClass, ex);
        }
    }
}

