/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly.selector;

import jodd.csselly.Selector;
import jodd.csselly.selector.Match;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeFilter;

public class AttributeSelector
extends Selector
implements NodeFilter {
    protected final String name;
    protected final String value;
    protected final Match match;
    protected char quoteChar;

    public AttributeSelector(String name, String sign, String value) {
        super(Selector.Type.ATTRIBUTE);
        this.name = name.trim();
        this.value = this.extractValue(value);
        this.match = Match.valueOf(sign);
    }

    public AttributeSelector(String name, Match match, String value) {
        super(Selector.Type.ATTRIBUTE);
        this.name = name.trim();
        this.match = match;
        this.value = this.extractValue(value);
    }

    public AttributeSelector(String attr) {
        super(Selector.Type.ATTRIBUTE);
        int index = attr.indexOf(61);
        if (index == -1) {
            this.name = attr.trim();
            this.match = null;
            this.value = null;
            return;
        }
        char first = attr.charAt(index - 1);
        this.match = Match.valueOfFirstChar(first);
        int signLen = this.match.getSign().length();
        this.name = attr.substring(0, index -= signLen - 1).trim();
        this.value = this.extractValue(attr.substring(index + signLen));
    }

    protected String extractValue(String value) {
        this.quoteChar = value.charAt(0);
        if (this.quoteChar != '\"' && this.quoteChar != '\'') {
            this.quoteChar = '\u0000';
        }
        if (this.quoteChar != '\u0000') {
            value = value.substring(1, value.length() - 1);
        }
        return value.trim();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Match getMatch() {
        return this.match;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    @Override
    public boolean accept(Node node) {
        if (!node.hasAttribute(this.name)) {
            return false;
        }
        if (this.value == null) {
            return true;
        }
        String nodeValue = node.getAttribute(this.name);
        if (nodeValue == null) {
            return false;
        }
        return this.match.compare(nodeValue, this.value);
    }
}

