/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import jodd.db.DbQueryNamedParameter;
import jodd.db.DbSqlException;
import jodd.util.CharUtil;
import jodd.util.StringUtil;

class DbQueryParser {
    public static final String SQL_SEPARATORS = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\";
    boolean prepared;
    boolean callable;
    String sql;
    private DbQueryNamedParameter rootNP;
    private Map<String, Integer> batchParams;

    DbQueryParser(String sql) {
        this.parseSql(sql);
    }

    void storeNamedParameter(String name, int position) {
        DbQueryNamedParameter p = this.lookupNamedParameter(name);
        if (p == null) {
            p = new DbQueryNamedParameter(name);
            p.indices = new int[]{position};
            p.next = this.rootNP;
            this.rootNP = p;
        } else {
            p.add(position);
        }
    }

    DbQueryNamedParameter lookupNamedParameter(String name) {
        DbQueryNamedParameter p = this.rootNP;
        while (p != null) {
            if (p.equalsName(name)) {
                return p;
            }
            p = p.next;
        }
        return null;
    }

    int[] getNamedParameterIndices(String name) {
        DbQueryNamedParameter p = this.lookupNamedParameter(name);
        if (p == null) {
            throw new DbSqlException("Named parameter not found: " + name + "\nQuery: " + this.sql);
        }
        return p.indices;
    }

    void forEachNamedParameter(Consumer<DbQueryNamedParameter> consumer) {
        DbQueryNamedParameter p = this.rootNP;
        while (p != null) {
            consumer.accept(p);
            p = p.next;
        }
    }

    private void saveBatchParameter(String name, int size) {
        if (this.batchParams == null) {
            this.batchParams = new HashMap<String, Integer>();
        }
        this.batchParams.put(name, size);
    }

    protected int getBatchParameterSize(String name) {
        if (this.batchParams == null) {
            return 0;
        }
        Integer size = this.batchParams.get(name);
        if (size == null) {
            return 0;
        }
        return size;
    }

    void parseSql(String sqlString) {
        this.rootNP = null;
        int stringLength = sqlString.length();
        StringBuilder pureSql = new StringBuilder(stringLength);
        boolean inQuote = false;
        int index = 0;
        int paramCount = 0;
        while (index < stringLength) {
            char c = sqlString.charAt(index);
            if (inQuote) {
                if (c == '\'') {
                    inQuote = false;
                }
            } else if (c == '\'') {
                inQuote = true;
            } else {
                int right;
                if (c == ':') {
                    right = StringUtil.indexOfChars(sqlString, SQL_SEPARATORS, index + 1);
                    boolean batch = false;
                    if (right < 0) {
                        right = stringLength;
                    } else if (sqlString.charAt(right) == '!') {
                        batch = true;
                    }
                    String param = sqlString.substring(index + 1, right);
                    if (!batch) {
                        this.storeNamedParameter(param, ++paramCount);
                        pureSql.append('?');
                    } else {
                        int batchSize;
                        int numStart = ++right;
                        while (right < stringLength && CharUtil.isDigit(sqlString.charAt(right))) {
                            ++right;
                        }
                        String numberValue = sqlString.substring(numStart, right);
                        try {
                            batchSize = Integer.parseInt(numberValue);
                        }
                        catch (NumberFormatException nfex) {
                            throw new DbSqlException("Batch size is not an integer: " + numberValue, nfex);
                        }
                        this.saveBatchParameter(param, batchSize);
                        for (int i = 1; i <= batchSize; ++i) {
                            if (i != 1) {
                                pureSql.append(',');
                            }
                            this.storeNamedParameter(param + '.' + i, ++paramCount);
                            pureSql.append('?');
                        }
                    }
                    index = right;
                    continue;
                }
                if (c == '?') {
                    if (index < stringLength - 1 && Character.isDigit(sqlString.charAt(index + 1))) {
                        right = StringUtil.indexOfChars(sqlString, SQL_SEPARATORS, index + 1);
                        if (right < 0) {
                            right = stringLength;
                        }
                        String param = sqlString.substring(index + 1, right);
                        try {
                            Integer.parseInt(param);
                        }
                        catch (NumberFormatException nfex) {
                            throw new DbSqlException("Positional parameter is not an integer: " + param, nfex);
                        }
                        this.storeNamedParameter(param, ++paramCount);
                        pureSql.append('?');
                        index = right;
                        continue;
                    }
                    ++paramCount;
                }
            }
            pureSql.append(c);
            ++index;
        }
        this.prepared = paramCount != 0;
        this.sql = pureSql.toString();
        if (this.sql.startsWith("{")) {
            this.callable = true;
        }
    }
}

