/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.connection;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import jodd.db.DbSqlException;
import jodd.db.connection.ConnectionProvider;

public class XADataSourceConnectionProvider
implements ConnectionProvider {
    private final XADataSource xaDataSource;
    private final String username;
    private final String password;

    public XADataSourceConnectionProvider(XADataSource dataSource) {
        this.xaDataSource = dataSource;
        this.password = null;
        this.username = null;
    }

    public XADataSourceConnectionProvider(XADataSource dataSource, String user, String pass) {
        this.xaDataSource = dataSource;
        this.username = user;
        this.password = pass;
    }

    @Override
    public void init() {
    }

    @Override
    public Connection getConnection() {
        try {
            XAConnection xaConnection = this.username != null ? this.xaDataSource.getXAConnection(this.username, this.password) : this.xaDataSource.getXAConnection();
            return xaConnection.getConnection();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to get connection from XA datasource", sex);
        }
    }

    @Override
    public void closeConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
    }
}

