/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen.chunks;

import jodd.bean.BeanUtil;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbEntityManager;
import jodd.db.oom.sqlgen.DbSqlBuilderException;
import jodd.db.oom.sqlgen.chunks.SqlChunk;
import jodd.util.StringUtil;

public class MatchChunk
extends SqlChunk {
    private static final String AND = " and ";
    private static final String DEFAULT = "1=1";
    private static final String DOT_STAR = ".*";
    private static final String DOT_PLUS = ".+";
    protected Object data;
    protected final String tableRef;
    protected final String objectRef;
    protected final int includeColumns;

    public MatchChunk(DbEntityManager dbEntityManager, String tableRef, Object data, int includeColumns) {
        this(dbEntityManager, tableRef, null, data, includeColumns);
    }

    public MatchChunk(DbEntityManager dbEntityManager, String tableRef, String objectRef, int includeColumns) {
        this(dbEntityManager, tableRef, objectRef, null, includeColumns);
    }

    private MatchChunk(DbEntityManager dbEntityManager, String tableRef, String objectRef, Object data, int includeColumns) {
        super(dbEntityManager, 4);
        this.tableRef = tableRef;
        this.objectRef = objectRef;
        this.data = data;
        this.includeColumns = includeColumns;
    }

    public MatchChunk(DbEntityManager dbEntityManager, String expression) {
        super(dbEntityManager, 4);
        expression = expression.trim();
        int lastNdx = expression.length();
        if (expression.endsWith(DOT_STAR)) {
            lastNdx -= 2;
            this.includeColumns = 3;
        } else if (expression.endsWith(DOT_PLUS)) {
            lastNdx -= 2;
            this.includeColumns = 2;
        } else {
            this.includeColumns = 1;
        }
        int eq = expression.indexOf(61);
        if (eq == -1) {
            throw new DbSqlBuilderException("Syntax error, expected 'match' equality: {tableRef=objectRef}.");
        }
        this.tableRef = expression.substring(0, eq).trim();
        this.objectRef = expression.substring(eq + 1, lastNdx).trim();
    }

    @Override
    public void process(StringBuilder out) {
        if (this.objectRef != null) {
            this.data = this.templateData.lookupObject(this.objectRef);
        }
        DbEntityDescriptor ded = this.tableRef != null ? this.lookupTableRef(this.tableRef) : this.lookupType(MatchChunk.resolveClass(this.data));
        String table = this.resolveTable(this.tableRef, ded);
        DbEntityColumnDescriptor[] decList = ded.getColumnDescriptors();
        String typeName = StringUtil.uncapitalize(ded.getEntityName());
        int count = 0;
        out.append('(');
        for (DbEntityColumnDescriptor dec : decList) {
            if (this.includeColumns == 2 && !dec.isId()) continue;
            String property = dec.getPropertyName();
            Object value = BeanUtil.declaredSilent.getProperty(this.data, property);
            if (this.includeColumns == 1 && value == null || this.includeColumns == 1 && this.isEmptyColumnValue(dec, value)) continue;
            if (count > 0) {
                out.append(AND);
            }
            ++count;
            out.append(table).append('.').append(dec.getColumnName()).append('=');
            String propertyName = this.objectRef != null ? this.objectRef : typeName;
            propertyName = propertyName + '.' + property;
            this.defineParameter(out, propertyName, value, dec);
        }
        if (count == 0) {
            out.append(DEFAULT);
        }
        out.append(')');
    }
}

