/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen.chunks;

import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbEntityManager;
import jodd.db.oom.sqlgen.DbSqlBuilderException;
import jodd.db.oom.sqlgen.TemplateData;
import jodd.util.CharUtil;
import jodd.util.StringUtil;

public abstract class SqlChunk {
    public static final int COLS_NA = 0;
    public static final int COLS_ONLY_EXISTING = 1;
    public static final int COLS_ONLY_IDS = 2;
    public static final int COLS_ALL = 3;
    public static final int COLS_ALL_BUT_ID = 4;
    public static final int COLS_NA_MULTI = 0;
    public static final int CHUNK_RAW = -1;
    public static final int CHUNK_SELECT_COLUMNS = 1;
    public static final int CHUNK_TABLE = 2;
    public static final int CHUNK_REFERENCE = 3;
    public static final int CHUNK_MATCH = 4;
    public static final int CHUNK_VALUE = 5;
    public static final int CHUNK_INSERT = 5;
    public static final int CHUNK_UPDATE = 6;
    private final int chunkType;
    private final DbEntityManager dbEntityManager;
    protected SqlChunk previousChunk;
    protected SqlChunk nextChunk;
    protected TemplateData templateData;

    protected SqlChunk(DbEntityManager dbEntityManager, int chunkType) {
        this.dbEntityManager = dbEntityManager;
        this.chunkType = chunkType;
    }

    public SqlChunk getPreviousChunk() {
        return this.previousChunk;
    }

    public SqlChunk getNextChunk() {
        return this.nextChunk;
    }

    public void insertChunkAfter(SqlChunk previous) {
        SqlChunk next = previous.nextChunk;
        previous.nextChunk = this;
        this.previousChunk = previous;
        if (next != null) {
            next.previousChunk = this;
            this.nextChunk = next;
        }
    }

    public boolean isPreviousChunkOfType(int type) {
        if (this.previousChunk == null) {
            return false;
        }
        return this.previousChunk.chunkType == type;
    }

    public boolean isPreviousChunkOfSameType() {
        if (this.previousChunk == null) {
            return false;
        }
        return this.previousChunk.chunkType == this.chunkType;
    }

    public boolean isPreviousMacroChunk() {
        if (this.previousChunk == null) {
            return false;
        }
        return this.previousChunk.chunkType != -1;
    }

    public boolean isPreviousRawChunk() {
        if (this.previousChunk == null) {
            return false;
        }
        return this.previousChunk.chunkType == -1;
    }

    public void init(TemplateData templateData) {
        this.templateData = templateData;
    }

    public abstract void process(StringBuilder var1);

    protected DbEntityDescriptor lookupName(String entityName) {
        DbEntityDescriptor ded = this.dbEntityManager.lookupName(entityName);
        if (ded == null) {
            throw new DbSqlBuilderException("Entity name not registered: " + entityName);
        }
        return ded;
    }

    protected DbEntityDescriptor lookupType(Class entity) {
        DbEntityDescriptor ded = this.dbEntityManager.lookupType(entity);
        if (ded == null) {
            throw new DbSqlBuilderException("Invalid or not-persistent entity: " + entity.getName());
        }
        return ded;
    }

    protected DbEntityDescriptor lookupTableRef(String tableRef) {
        return this.lookupTableRef(tableRef, true);
    }

    protected DbEntityDescriptor lookupTableRef(String tableRef, boolean throwExceptionIfNotFound) {
        DbEntityDescriptor ded = this.templateData.getTableDescriptor(tableRef);
        if (ded == null && throwExceptionIfNotFound) {
            throw new DbSqlBuilderException("Invalid table reference: " + tableRef);
        }
        return ded;
    }

    protected DbEntityDescriptor findColumnRef(String columnRef) {
        DbEntityDescriptor ded = this.templateData.findTableDescriptorByColumnRef(columnRef);
        if (ded == null) {
            throw new DbSqlBuilderException("Invalid column reference: " + columnRef);
        }
        return ded;
    }

    protected String resolveTable(String tableRef, DbEntityDescriptor ded) {
        String tableAlias = this.templateData.getTableAlias(tableRef);
        if (tableAlias != null) {
            return tableAlias;
        }
        return ded.getTableName();
    }

    protected void defineParameter(StringBuilder query, String name, Object value, DbEntityColumnDescriptor dec) {
        if (name == null) {
            name = this.templateData.getNextParameterName();
        }
        query.append(':').append(name);
        this.templateData.addParameter(name, value, dec);
    }

    protected static Class resolveClass(Object object) {
        Class type = object.getClass();
        return type == Class.class ? (Class)object : type;
    }

    protected boolean isEmptyColumnValue(DbEntityColumnDescriptor dec, Object value) {
        int n;
        if (value == null) {
            return true;
        }
        if (dec.isId() && value instanceof Number && ((Number)value).intValue() == 0) {
            return true;
        }
        if (dec.getPropertyType().isPrimitive() && (n = ((Number)value).intValue()) == 0) {
            return true;
        }
        return value instanceof CharSequence && StringUtil.isBlank((CharSequence)value);
    }

    protected void appendMissingSpace(StringBuilder out) {
        int len = out.length();
        if (len == 0) {
            return;
        }
        if (!CharUtil.isWhitespace(out.charAt(--len))) {
            out.append(' ');
        }
    }

    protected void separateByCommaOrSpace(StringBuilder out) {
        if (this.isPreviousChunkOfSameType()) {
            out.append(',').append(' ');
        } else {
            this.appendMissingSpace(out);
        }
    }
}

