/*
 * Decompiled with CFR 0.152.
 */
package jodd.htmlstapler;

import java.util.ArrayList;
import java.util.List;
import jodd.htmlstapler.HtmlStaplerBundlesManager;
import jodd.util.ArraysUtil;

public class BundleAction {
    private static final String BUNDLE_ID_MARKER = "---jodd-bundle-id-marker---";
    private static final String UNSTAPLE_MARKER = "jodd-unstaple";
    protected final HtmlStaplerBundlesManager bundlesManager;
    protected final String bundleContentType;
    protected final boolean newAction;
    protected final String actionPath;
    protected final String contextPath;
    protected final HtmlStaplerBundlesManager.Strategy strategy;
    protected String bundleId;
    protected char[] bundleIdMark;
    protected List<String> sources;
    protected boolean firstScriptTag;

    public BundleAction(HtmlStaplerBundlesManager bundlesManager, String servletPath, String bundleContentType) {
        this.bundlesManager = bundlesManager;
        this.bundleContentType = bundleContentType;
        this.strategy = bundlesManager.getStrategy();
        String realActionPath = bundlesManager.resolveRealActionPath(servletPath);
        this.actionPath = realActionPath + '*' + bundleContentType;
        this.contextPath = bundlesManager.contextPath;
        if (this.strategy == HtmlStaplerBundlesManager.Strategy.ACTION_MANAGED) {
            this.bundleId = bundlesManager.lookupBundleId(this.actionPath);
            boolean bl = this.newAction = this.bundleId == null;
            if (this.newAction) {
                this.sources = new ArrayList<String>();
            }
        } else {
            this.bundleId = BUNDLE_ID_MARKER + bundleContentType;
            this.bundleIdMark = this.bundleId.toCharArray();
            this.newAction = true;
            this.sources = new ArrayList<String>();
        }
        this.firstScriptTag = true;
    }

    public boolean acceptLink(String src) {
        if (src == null) {
            return false;
        }
        return !src.contains(UNSTAPLE_MARKER);
    }

    public String processLink(String src) {
        if (this.newAction) {
            if (this.bundleId == null) {
                this.bundleId = this.bundlesManager.registerNewBundleId();
                this.bundleId = this.bundleId + '.' + this.bundleContentType;
            }
            this.sources.add(src);
        }
        if (this.firstScriptTag) {
            this.firstScriptTag = false;
            return this.buildStaplerUrl();
        }
        return null;
    }

    protected String buildStaplerUrl() {
        return this.contextPath + '/' + this.bundlesManager.getStaplerPath() + '/' + this.bundleId;
    }

    public void end() {
        if (this.newAction) {
            this.bundleId = this.bundlesManager.registerBundle(this.contextPath, this.actionPath, this.bundleId, this.bundleContentType, this.sources);
        }
    }

    public char[] replaceBundleId(char[] content) {
        if (this.strategy == HtmlStaplerBundlesManager.Strategy.ACTION_MANAGED || this.bundleId == null) {
            return content;
        }
        int index = ArraysUtil.indexOf(content, this.bundleIdMark);
        if (index == -1) {
            return content;
        }
        char[] bundleIdChars = this.bundleId.toCharArray();
        char[] result = new char[content.length - this.bundleIdMark.length + bundleIdChars.length];
        System.arraycopy(content, 0, result, 0, index);
        System.arraycopy(bundleIdChars, 0, result, index, bundleIdChars.length);
        System.arraycopy(content, index + this.bundleIdMark.length, result, index + bundleIdChars.length, content.length - this.bundleIdMark.length - index);
        return result;
    }
}

