/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import jodd.bridge.Packages;
import jodd.introspector.Mapper;
import jodd.introspector.MapperFunction;
import jodd.introspector.MapperFunctionInstances;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionHandler;
import jodd.madvoc.MadvocException;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.component.ActionConfigManager;
import jodd.madvoc.component.ActionMethodParamNameResolver;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.RootPackages;
import jodd.madvoc.component.ScopeDataInspector;
import jodd.madvoc.config.ActionDefinition;
import jodd.madvoc.config.ActionNames;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.config.MethodParam;
import jodd.madvoc.config.ScopeData;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.Action;
import jodd.madvoc.meta.ActionAnnotationValues;
import jodd.madvoc.meta.Async;
import jodd.madvoc.meta.Auth;
import jodd.madvoc.meta.FilteredBy;
import jodd.madvoc.meta.InterceptedBy;
import jodd.madvoc.meta.MadvocAction;
import jodd.madvoc.meta.RenderWith;
import jodd.madvoc.meta.method.DELETE;
import jodd.madvoc.meta.method.GET;
import jodd.madvoc.meta.method.HEAD;
import jodd.madvoc.meta.method.OPTIONS;
import jodd.madvoc.meta.method.PATCH;
import jodd.madvoc.meta.method.POST;
import jodd.madvoc.meta.method.PUT;
import jodd.madvoc.meta.method.TRACE;
import jodd.madvoc.path.ActionNamingStrategy;
import jodd.madvoc.result.ActionResult;
import jodd.madvoc.result.NoneActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.util.ArraysUtil;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;

public class ActionMethodParser {
    private static final Class<? extends Annotation>[] METHOD_ANNOTATIONS = new Class[]{DELETE.class, GET.class, HEAD.class, POST.class, PUT.class, OPTIONS.class, TRACE.class, PATCH.class};
    @PetiteInject
    protected ContextInjectorComponent contextInjectorComponent;
    @PetiteInject
    protected ActionConfigManager actionConfigManager;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected InterceptorsManager interceptorsManager;
    @PetiteInject
    protected FiltersManager filtersManager;
    @PetiteInject
    protected RootPackages rootPackages;
    @PetiteInject
    protected ScopeDataInspector scopeDataInspector;
    @PetiteInject
    protected ActionMethodParamNameResolver actionMethodParamNameResolver;

    public ActionDefinition parseActionDefinition(Class<?> actionClass, Method actionMethod) {
        ActionNamingStrategy namingStrategy;
        ActionAnnotationValues annotationValues = this.detectActionAnnotationValues(actionMethod);
        ActionConfig actionConfig = this.resolveActionConfig(annotationValues);
        String[] packageActionNames = this.readPackageActionPath(actionClass);
        String[] classActionNames = this.readClassActionPath(actionClass);
        String[] methodActionNames = this.readMethodActionPath(actionMethod.getName(), annotationValues, actionConfig);
        String method = this.readMethodHttpMethod(actionMethod);
        ActionNames actionNames = new ActionNames(packageActionNames, classActionNames, methodActionNames, method);
        try {
            namingStrategy = ClassUtil.newInstance(actionConfig.getNamingStrategy());
            this.contextInjectorComponent.injectContext(namingStrategy);
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
        return namingStrategy.buildActionDef(actionClass, actionMethod, actionNames);
    }

    public ActionRuntime parse(Class<?> actionClass, Method actionMethod, ActionDefinition actionDefinition) {
        ActionAnnotationValues annotationValues = this.detectActionAnnotationValues(actionMethod);
        ActionConfig actionConfig = this.resolveActionConfig(annotationValues);
        ActionInterceptor[] actionInterceptors = this.parseActionInterceptors(actionClass, actionMethod, actionConfig);
        ActionFilter[] actionFilters = this.parseActionFilters(actionClass, actionMethod, actionConfig);
        if (actionDefinition == null) {
            actionDefinition = this.parseActionDefinition(actionClass, actionMethod);
        }
        this.detectAndRegisterAlias(annotationValues, actionDefinition);
        boolean async = this.parseMethodAsyncFlag(actionMethod);
        boolean auth = this.parseMethodAuthFlag(actionMethod);
        Class<? extends ActionResult> actionResult = this.parseActionResult(actionMethod);
        Class<? extends ActionResult> defaultActionResult = actionConfig.getActionResult();
        return this.createActionRuntime(null, actionClass, actionMethod, actionResult, defaultActionResult, actionFilters, actionInterceptors, actionDefinition, async, auth);
    }

    protected ActionConfig resolveActionConfig(ActionAnnotationValues annotationValues) {
        Class annotationType = annotationValues == null ? Action.class : annotationValues.annotationType();
        return this.actionConfigManager.lookup(annotationType);
    }

    protected ActionAnnotationValues detectActionAnnotationValues(Method actionMethod) {
        return this.actionConfigManager.readAnnotationValue(actionMethod);
    }

    protected void detectAndRegisterAlias(ActionAnnotationValues annotationValues, ActionDefinition actionDefinition) {
        String alias = this.parseMethodAlias(annotationValues);
        if (alias != null) {
            String aliasPath = StringUtil.cutToIndexOf(actionDefinition.actionPath(), "#");
            this.actionsManager.registerPathAlias(alias, aliasPath);
        }
    }

    protected Class<? extends ActionResult> parseActionResult(Method actionMethod) {
        RenderWith renderWith = actionMethod.getAnnotation(RenderWith.class);
        if (renderWith != null) {
            return renderWith.value();
        }
        return null;
    }

    protected ActionInterceptor[] parseActionInterceptors(Class<?> actionClass, Method actionMethod, ActionConfig actionConfig) {
        Class[] interceptorClasses = this.readActionInterceptors(actionMethod);
        if (interceptorClasses == null) {
            interceptorClasses = this.readActionInterceptors(actionClass);
        }
        if (interceptorClasses == null) {
            interceptorClasses = actionConfig.getInterceptors();
        }
        return (ActionInterceptor[])this.interceptorsManager.resolveAll(interceptorClasses);
    }

    protected ActionFilter[] parseActionFilters(Class<?> actionClass, Method actionMethod, ActionConfig actionConfig) {
        Class[] filterClasses = this.readActionFilters(actionMethod);
        if (filterClasses == null) {
            filterClasses = this.readActionFilters(actionClass);
        }
        if (filterClasses == null) {
            filterClasses = actionConfig.getFilters();
        }
        return (ActionFilter[])this.filtersManager.resolveAll(filterClasses);
    }

    protected Class<? extends ActionInterceptor>[] readActionInterceptors(AnnotatedElement actionClassOrMethod) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionClassOrMethod.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionFilter>[] readActionFilters(AnnotatedElement actionClassOrMethod) {
        Class<? extends ActionFilter>[] result = null;
        FilteredBy filteredBy = actionClassOrMethod.getAnnotation(FilteredBy.class);
        if (filteredBy != null && (result = filteredBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected String[] readPackageActionPath(Class actionClass) {
        String actionPackageName;
        block5: {
            String packageActionPathFromAnnotation;
            Package actionPackage = actionClass.getPackage();
            actionPackageName = actionPackage.getName();
            block0: while (true) {
                MadvocAction madvocActionAnnotation;
                String string = packageActionPathFromAnnotation = (madvocActionAnnotation = actionPackage.getAnnotation(MadvocAction.class)) != null ? madvocActionAnnotation.value().trim() : null;
                if (StringUtil.isEmpty(packageActionPathFromAnnotation)) {
                    packageActionPathFromAnnotation = null;
                }
                if (packageActionPathFromAnnotation != null) break;
                String newPackage = actionPackage.getName();
                actionPackage = null;
                while (true) {
                    if (actionPackage != null) continue block0;
                    int ndx = newPackage.lastIndexOf(46);
                    if (ndx != -1) {
                        newPackage = newPackage.substring(0, ndx);
                        actionPackage = Packages.of(actionClass.getClassLoader(), newPackage);
                        continue;
                    }
                    break block5;
                    break;
                }
                break;
            }
            this.rootPackages.addRootPackage(actionPackage.getName(), packageActionPathFromAnnotation);
        }
        String packagePath = this.rootPackages.findPackagePathForActionPackage(actionPackageName);
        if (packagePath == null) {
            return ArraysUtil.array(null, null);
        }
        return ArraysUtil.array(StringUtil.stripChar(packagePath, '/'), StringUtil.surround(packagePath, "/"));
    }

    protected String[] readClassActionPath(Class actionClass) {
        String classActionPath;
        MadvocAction madvocActionAnnotation = actionClass.getAnnotation(MadvocAction.class);
        String string = classActionPath = madvocActionAnnotation != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty(classActionPath)) {
            classActionPath = null;
        }
        String actionClassName = actionClass.getSimpleName();
        actionClassName = StringUtil.uncapitalize(actionClassName);
        actionClassName = MadvocUtil.stripLastCamelWord(actionClassName);
        if (classActionPath == null) {
            classActionPath = actionClassName;
        }
        return ArraysUtil.array(actionClassName, classActionPath);
    }

    protected String[] readMethodActionPath(String methodName, ActionAnnotationValues annotationValues, ActionConfig actionConfig) {
        String methodActionPath;
        String string = methodActionPath = annotationValues != null ? annotationValues.value() : null;
        if (methodActionPath == null) {
            methodActionPath = methodName;
        } else if (methodActionPath.equals("#")) {
            return ArraysUtil.array(null, null);
        }
        for (String path : actionConfig.getActionMethodNames()) {
            if (!methodActionPath.equals(path)) continue;
            methodActionPath = null;
            break;
        }
        return ArraysUtil.array(methodName, methodActionPath);
    }

    protected String parseMethodAlias(ActionAnnotationValues annotationValues) {
        String alias = null;
        if (annotationValues != null) {
            alias = annotationValues.alias();
        }
        return alias;
    }

    private String readMethodHttpMethod(Method actionMethod) {
        for (Class<? extends Annotation> methodAnnotation : METHOD_ANNOTATIONS) {
            if (actionMethod.getAnnotation(methodAnnotation) == null) continue;
            return methodAnnotation.getSimpleName();
        }
        return null;
    }

    private boolean parseMethodAsyncFlag(Method actionMethod) {
        return actionMethod.getAnnotation(Async.class) != null;
    }

    private boolean parseMethodAuthFlag(Method actionMethod) {
        if (actionMethod.getAnnotation(Auth.class) != null) {
            return true;
        }
        Class<?> declaringClass = actionMethod.getDeclaringClass();
        if (declaringClass.getAnnotation(Auth.class) != null) {
            return true;
        }
        return declaringClass.getPackage().getAnnotation(Auth.class) != null;
    }

    public ActionRuntime createActionRuntime(ActionHandler actionHandler, Class actionClass, Method actionClassMethod, Class<? extends ActionResult> actionResult, Class<? extends ActionResult> defaultActionResult, ActionFilter[] filters, ActionInterceptor[] interceptors, ActionDefinition actionDefinition, boolean async, boolean auth) {
        if (actionHandler != null) {
            return new ActionRuntime(actionHandler, actionClass, actionClassMethod, filters, interceptors, actionDefinition, NoneActionResult.class, NoneActionResult.class, async, auth, null, null);
        }
        ScopeData scopeData = this.scopeDataInspector.inspectClassScopes(actionClass);
        Class<?>[] paramTypes = actionClassMethod.getParameterTypes();
        MethodParam[] params = new MethodParam[paramTypes.length];
        Annotation[][] paramAnns = actionClassMethod.getParameterAnnotations();
        String[] methodParamNames = null;
        for (int ndx = 0; ndx < paramTypes.length; ++ndx) {
            Class<?> paramType = paramTypes[ndx];
            if (methodParamNames == null) {
                methodParamNames = this.actionMethodParamNameResolver.resolveParamNames(actionClassMethod);
            }
            void paramName = methodParamNames[ndx];
            Annotation[] parameterAnnotations = paramAnns[ndx];
            ScopeData paramsScopeData = this.scopeDataInspector.inspectMethodParameterScopes((String)paramName, paramType, parameterAnnotations);
            MapperFunction mapperFunction = null;
            for (Annotation annotation : parameterAnnotations) {
                if (!(annotation instanceof Mapper)) continue;
                mapperFunction = MapperFunctionInstances.get().lookup(((Mapper)annotation).value());
                break;
            }
            params[ndx] = new MethodParam(paramTypes[ndx], (String)paramName, this.scopeDataInspector.detectAnnotationType(parameterAnnotations), paramsScopeData, mapperFunction);
        }
        return new ActionRuntime(null, actionClass, actionClassMethod, filters, interceptors, actionDefinition, actionResult, defaultActionResult, async, auth, scopeData, params);
    }
}

