/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.config;

import jodd.madvoc.scope.MadvocScope;

public class InjectionPoint {
    private final Class type;
    private final String name;
    private final String targetName;
    private final MadvocScope scope;

    public InjectionPoint(Class type, String name, String targetName, MadvocScope scope) {
        this.type = type;
        this.name = name;
        this.targetName = targetName;
        this.scope = scope;
    }

    public Class type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public MadvocScope scope() {
        return this.scope;
    }

    public String targetName() {
        return this.targetName != null ? this.targetName : this.name;
    }

    public String matchedName(String value) {
        char c;
        if (!value.startsWith(this.name)) {
            return null;
        }
        int requiredLen = this.name.length();
        if (value.length() >= requiredLen + 1 && (c = value.charAt(requiredLen)) != '.' && c != '[') {
            return null;
        }
        if (this.targetName == null) {
            return value;
        }
        return this.targetName + value.substring(this.name.length());
    }
}

