/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.scope;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.Targets;
import jodd.madvoc.scope.MadvocScope;

public class SessionScope
implements MadvocScope {
    @Override
    public void inject(ActionRequest actionRequest, Targets targets) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpSession session = servletRequest.getSession();
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            targets.forEachTargetAndIn(this, (target, in) -> {
                String name = in.matchedName(attrName);
                if (name != null) {
                    Object attrValue = session.getAttribute(attrName);
                    target.writeValue(name, attrValue, true);
                }
            });
        }
    }

    @Override
    public void inject(ServletContext servletContext, Targets targets) {
    }

    @Override
    public void inject(Targets targets) {
    }

    @Override
    public void outject(ActionRequest actionRequest, Targets targets) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpSession session = servletRequest.getSession();
        targets.forEachTargetAndOut(this, (target, out) -> {
            Object value = target.readValue((InjectionPoint)out);
            session.setAttribute(out.name(), value);
        });
    }
}

