/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.util.Objects;
import java.util.Properties;
import javax.mail.Authenticator;
import jodd.mail.ImapServer;
import jodd.mail.ImapSslServer;
import jodd.mail.MailSession;
import jodd.mail.Pop3Server;
import jodd.mail.Pop3SslServer;
import jodd.mail.SimpleAuthenticator;
import jodd.mail.SmtpServer;
import jodd.mail.SmtpSslServer;

public abstract class MailServer<MailSessionImpl extends MailSession> {
    private final String host;
    private final int port;
    private final Authenticator authenticator;
    private final File attachmentStorage;
    private final Properties sessionProperties;

    protected MailServer(String host, int port, Authenticator authenticator, File attachmentStorage) {
        Objects.requireNonNull(host, "Host cannot be null");
        this.host = host;
        this.port = port;
        this.authenticator = authenticator;
        this.attachmentStorage = attachmentStorage;
        this.sessionProperties = this.createSessionProperties();
    }

    public abstract MailSessionImpl createSession();

    protected abstract Properties createSessionProperties();

    public String getHost() {
        return this.host;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public int getPort() {
        return this.port;
    }

    public Properties getSessionProperties() {
        return this.sessionProperties;
    }

    public File getAttachmentStorage() {
        return this.attachmentStorage;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private String host = null;
        private int port = -1;
        private boolean ssl = false;
        private Authenticator authenticator;
        private File attachmentStorage;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder storeAttachmentsIn(File attachmentStorage) {
            this.attachmentStorage = attachmentStorage;
            return this;
        }

        public Builder auth(String username, String password) {
            Objects.requireNonNull(username, "Username cannot be null");
            Objects.requireNonNull(password, "Password cannot be null");
            return this.auth(new SimpleAuthenticator(username, password));
        }

        public Builder auth(Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public ImapServer buildImapMailServer() {
            if (this.ssl) {
                return new ImapSslServer(this.host, this.port, this.authenticator, this.attachmentStorage);
            }
            return new ImapServer(this.host, this.port, this.authenticator, this.attachmentStorage);
        }

        public Pop3Server buildPop3MailServer() {
            if (this.ssl) {
                return new Pop3SslServer(this.host, this.port, this.authenticator, this.attachmentStorage);
            }
            return new Pop3Server(this.host, this.port, this.authenticator, this.attachmentStorage);
        }

        public SmtpServer buildSmtpMailServer() {
            if (this.ssl) {
                return new SmtpSslServer(this.host, this.port, this.authenticator);
            }
            return new SmtpServer(this.host, this.port, this.authenticator);
        }
    }
}

