/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.util.ArrayList;
import java.util.Collection;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.PropertyDescriptor;
import jodd.petite.def.BeanReferences;
import jodd.petite.def.PropertyInjectionPoint;
import jodd.petite.resolver.ReferencesResolver;
import jodd.util.ClassUtil;

public class PropertyResolver {
    protected final ReferencesResolver referencesResolver;

    public PropertyResolver(ReferencesResolver referencesResolver) {
        this.referencesResolver = referencesResolver;
    }

    public PropertyInjectionPoint[] resolve(Class type, boolean autowire) {
        PropertyDescriptor[] allPropertyDescriptors;
        ClassDescriptor cd = ClassIntrospector.get().lookup(type);
        ArrayList<PropertyInjectionPoint> list = new ArrayList<PropertyInjectionPoint>();
        for (PropertyDescriptor propertyDescriptor : allPropertyDescriptors = cd.getAllPropertyDescriptors()) {
            Class propertyType;
            if (propertyDescriptor.isGetterOnly() || ClassUtil.isTypeOf(propertyType = propertyDescriptor.getType(), Collection.class)) continue;
            BeanReferences reference = this.referencesResolver.readReferenceFromAnnotation(propertyDescriptor);
            if (reference == null) {
                if (!autowire) continue;
                reference = this.referencesResolver.buildDefaultReference(propertyDescriptor);
            }
            list.add(new PropertyInjectionPoint(propertyDescriptor, reference));
        }
        PropertyInjectionPoint[] fields = list.isEmpty() ? PropertyInjectionPoint.EMPTY : list.toArray(new PropertyInjectionPoint[0]);
        return fields;
    }
}

