/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jodd.db.DbCallResult;
import jodd.db.DbOom;
import jodd.db.DbQueryParser;
import jodd.db.DbSession;
import jodd.db.DbSessionProvider;
import jodd.db.DbSqlException;
import jodd.db.DbUtil;
import jodd.db.QueryConcurrencyType;
import jodd.db.QueryHoldability;
import jodd.db.QueryMapper;
import jodd.db.QueryScrollType;
import jodd.db.debug.LogabbleStatementFactory;
import jodd.log.Logger;
import jodd.log.LoggerFactory;

abstract class DbQueryBase<Q extends DbQueryBase>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(DbQueryBase.class);
    protected final DbOom dbOom;
    protected State queryState = State.CREATED;
    protected Connection connection;
    protected DbSession session;
    protected String sqlString;
    protected Statement statement;
    protected PreparedStatement preparedStatement;
    protected CallableStatement callableStatement;
    protected Set<ResultSet> resultSets;
    protected DbQueryParser query;
    protected boolean forcePreparedStatement;
    protected boolean autoClose;
    protected QueryScrollType type;
    protected QueryConcurrencyType concurrencyType;
    protected QueryHoldability holdability;
    protected boolean debug;
    protected String[] generatedColumns;
    protected int fetchSize;
    protected int maxRows;
    protected long start;
    protected long elapsed = -1L;
    protected static int totalOpenResultSetCount;

    protected DbQueryBase(DbOom dbOom) {
        this.dbOom = dbOom;
        this.forcePreparedStatement = dbOom.queryConfig().isForcePreparedStatement();
        this.type = dbOom.queryConfig().getType();
        this.concurrencyType = dbOom.queryConfig().getConcurrencyType();
        this.holdability = dbOom.queryConfig().getHoldability();
        this.debug = dbOom.queryConfig().isDebug();
        this.fetchSize = dbOom.queryConfig().getFetchSize();
        this.maxRows = dbOom.queryConfig().getMaxRows();
    }

    protected Q _this() {
        return (Q)this;
    }

    public State getQueryState() {
        return this.queryState;
    }

    protected void checkNotClosed() {
        if (this.queryState == State.CLOSED) {
            throw new DbSqlException(this, "Query is closed. Operation may be performed only on active queries.");
        }
    }

    protected void checkCreated() {
        if (this.queryState != State.CREATED) {
            String message = this.queryState == State.INITIALIZED ? "Query is already initialized." : "Query is closed.";
            throw new DbSqlException(this, message + " Operation may be performed only on created queries.");
        }
    }

    protected void checkInitialized() {
        if (this.queryState != State.INITIALIZED) {
            String message = this.queryState == State.CREATED ? "Query is created but not yet initialized." : "Query is closed.";
            throw new DbSqlException(this, message + " Operation may be performed only on initialized queries.");
        }
    }

    public boolean isClosed() {
        return this.queryState == State.CLOSED;
    }

    public boolean isActive() {
        return this.queryState != State.CLOSED;
    }

    public boolean isInitialized() {
        return this.queryState == State.INITIALIZED;
    }

    public DbSession getSession() {
        return this.session;
    }

    protected void saveResultSet(ResultSet rs) {
        if (this.resultSets == null) {
            this.resultSets = new HashSet<ResultSet>();
        }
        this.resultSets.add(rs);
    }

    public Q forcePreparedStatement() {
        this.checkCreated();
        this.forcePreparedStatement = true;
        return this._this();
    }

    public final void init() {
        this.checkNotClosed();
        if (this.queryState == State.INITIALIZED) {
            return;
        }
        this.initializeJdbc();
        this.queryState = State.INITIALIZED;
        this.prepareQuery();
    }

    protected void initSession(DbSession session) {
        if (session != null) {
            this.session = session;
            return;
        }
        DbSessionProvider dbSessionProvider = this.dbOom.sessionProvider();
        this.session = dbSessionProvider.getDbSession();
    }

    protected void initializeJdbc() {
        if (this.connection == null) {
            this.initSession(this.session);
            this.connection = this.session.getConnection();
        }
        this.query = new DbQueryParser(this.sqlString);
        if (this.query.callable) {
            try {
                this.callableStatement = this.debug ? (this.holdability != QueryHoldability.DEFAULT ? LogabbleStatementFactory.callable().prepareCall(this.connection, this.query.sql, this.type.value(), this.concurrencyType.value(), this.holdability.value()) : LogabbleStatementFactory.callable().prepareCall(this.connection, this.query.sql, this.type.value(), this.concurrencyType.value())) : (this.holdability != QueryHoldability.DEFAULT ? this.connection.prepareCall(this.query.sql, this.type.value(), this.concurrencyType.value(), this.holdability.value()) : this.connection.prepareCall(this.query.sql, this.type.value(), this.concurrencyType.value()));
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Error creating callable statement", sex);
            }
            this.preparedStatement = this.callableStatement;
            this.statement = this.callableStatement;
            return;
        }
        if (this.query.prepared || this.forcePreparedStatement) {
            try {
                this.preparedStatement = this.debug ? (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? LogabbleStatementFactory.prepared().create(this.connection, this.query.sql, 1) : LogabbleStatementFactory.prepared().create(this.connection, this.query.sql, this.generatedColumns)) : (this.holdability != QueryHoldability.DEFAULT ? LogabbleStatementFactory.prepared().create(this.connection, this.query.sql, this.type.value(), this.concurrencyType.value(), this.holdability.value()) : LogabbleStatementFactory.prepared().create(this.connection, this.query.sql, this.type.value(), this.concurrencyType.value()))) : (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? this.connection.prepareStatement(this.query.sql, 1) : this.connection.prepareStatement(this.query.sql, this.generatedColumns)) : (this.holdability != QueryHoldability.DEFAULT ? this.connection.prepareStatement(this.query.sql, this.type.value(), this.concurrencyType.value(), this.holdability.value()) : this.connection.prepareStatement(this.query.sql, this.type.value(), this.concurrencyType.value())));
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Error creating prepared statement", sex);
            }
            this.statement = this.preparedStatement;
            return;
        }
        try {
            this.statement = this.holdability != QueryHoldability.DEFAULT ? this.connection.createStatement(this.type.value(), this.concurrencyType.value(), this.holdability.value()) : this.connection.createStatement(this.type.value(), this.concurrencyType.value());
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Error creating statement", sex);
        }
    }

    protected void prepareQuery() {
        if (this.fetchSize != 0) {
            this.setFetchSize(this.fetchSize);
        }
        if (this.maxRows != 0) {
            this.setMaxRows(this.maxRows);
        }
    }

    public Q autoClose() {
        this.autoClose = true;
        return this._this();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLException closeQueryResultSets() {
        SQLException sqlException = null;
        if (this.resultSets != null) {
            for (ResultSet rs : this.resultSets) {
                try {
                    rs.close();
                }
                catch (SQLException sex) {
                    if (sqlException == null) {
                        sqlException = sex;
                        continue;
                    }
                    sqlException.setNextException(sex);
                }
                finally {
                    --totalOpenResultSetCount;
                }
            }
            this.resultSets.clear();
            this.resultSets = null;
        }
        return sqlException;
    }

    public Q closeAllResultSets() {
        SQLException sex = this.closeQueryResultSets();
        if (sex != null) {
            throw new DbSqlException("Close associated ResultSets error", sex);
        }
        return this._this();
    }

    protected SQLException closeQuery() {
        SQLException sqlException = this.closeQueryResultSets();
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sex) {
                if (sqlException == null) {
                    sqlException = sex;
                }
                sqlException.setNextException(sex);
            }
            this.statement = null;
        }
        this.query = null;
        this.queryState = State.CLOSED;
        return sqlException;
    }

    @Override
    public void close() {
        SQLException sqlException = this.closeQuery();
        this.connection = null;
        if (this.session != null) {
            this.session.detachQuery(this);
        }
        if (sqlException != null) {
            throw new DbSqlException("Close query error", sqlException);
        }
    }

    public void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        if (!this.resultSets.remove(rs)) {
            throw new DbSqlException(this, "ResultSet is not created by this query");
        }
        try {
            rs.close();
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Close result set error", sex);
        }
        finally {
            --totalOpenResultSetCount;
        }
    }

    public QueryScrollType getType() {
        return this.type;
    }

    public Q setType(QueryScrollType type) {
        this.checkCreated();
        this.type = type;
        return this._this();
    }

    public Q typeForwardOnly() {
        this.setType(QueryScrollType.FORWARD_ONLY);
        return this._this();
    }

    public Q typeScrollSensitive() {
        this.setType(QueryScrollType.SCROLL_SENSITIVE);
        return this._this();
    }

    public Q typeScrollInsensitive() {
        this.setType(QueryScrollType.SCROLL_INSENSITIVE);
        return this._this();
    }

    public QueryConcurrencyType getConcurrencyType() {
        return this.concurrencyType;
    }

    public Q setConcurrencyType(QueryConcurrencyType concurrencyType) {
        this.checkCreated();
        this.concurrencyType = concurrencyType;
        return this._this();
    }

    public Q concurrentReadOnly() {
        this.setConcurrencyType(QueryConcurrencyType.READ_ONLY);
        return this._this();
    }

    public Q concurrentUpdatable() {
        this.setConcurrencyType(QueryConcurrencyType.UPDATABLE);
        return this._this();
    }

    public QueryHoldability getHoldability() {
        return this.holdability;
    }

    public Q setHoldability(QueryHoldability holdability) {
        this.checkCreated();
        this.holdability = holdability;
        return this._this();
    }

    public Q holdCursorsOverCommit() {
        this.setHoldability(QueryHoldability.HOLD_CURSORS_OVER_COMMIT);
        return this._this();
    }

    public Q closeCursorsAtCommit() {
        this.setHoldability(QueryHoldability.CLOSE_CURSORS_AT_COMMIT);
        return this._this();
    }

    public boolean isInDebugMode() {
        return this.debug;
    }

    public Q setDebug(boolean debug) {
        this.checkCreated();
        this.debug = debug;
        return this._this();
    }

    public Q setDebugMode() {
        this.setDebug(true);
        return this._this();
    }

    public String[] getGeneratedColumnNames() {
        return this.generatedColumns;
    }

    public Q setGeneratedColumns(String ... columns) {
        this.checkCreated();
        this.generatedColumns = columns;
        return this._this();
    }

    public Q setGeneratedKey() {
        this.setGeneratedColumns(new String[0]);
        return this._this();
    }

    public Q resetGeneratedColumns() {
        this.checkCreated();
        this.generatedColumns = null;
        return this._this();
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Q setFetchSize(int rows) {
        this.checkNotClosed();
        this.fetchSize = rows;
        if (this.statement != null) {
            try {
                this.statement.setFetchSize(this.fetchSize);
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Unable to set fetch size: " + this.fetchSize, sex);
            }
        }
        return this._this();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Q setMaxRows(int maxRows) {
        this.checkNotClosed();
        this.maxRows = maxRows;
        if (this.statement != null) {
            try {
                this.statement.setMaxRows(maxRows);
            }
            catch (SQLException sex) {
                throw new DbSqlException(this, "Unable to set max rows: " + maxRows, sex);
            }
        }
        return this._this();
    }

    public long getExecutionTime() {
        return this.elapsed;
    }

    public ResultSet execute() {
        this.start = System.currentTimeMillis();
        this.init();
        ResultSet rs = null;
        if (log.isDebugEnabled()) {
            log.debug("Executing statement: " + this.getQueryString());
        }
        try {
            rs = this.preparedStatement == null ? this.statement.executeQuery(this.query.sql) : this.preparedStatement.executeQuery();
            rs.setFetchSize(this.fetchSize);
        }
        catch (SQLException sex) {
            DbUtil.close(rs);
            throw new DbSqlException(this, "Query execution failed", sex);
        }
        this.saveResultSet(rs);
        ++totalOpenResultSetCount;
        this.elapsed = System.currentTimeMillis() - this.start;
        if (log.isDebugEnabled()) {
            log.debug("execution time: " + this.elapsed + "ms");
        }
        return rs;
    }

    public DbCallResult executeCall() {
        this.start = System.currentTimeMillis();
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("Calling statement: " + this.getQueryString());
        }
        try {
            this.callableStatement.execute();
        }
        catch (SQLException sex) {
            DbUtil.close(this.callableStatement);
            throw new DbSqlException(this, "Query execution failed", sex);
        }
        this.elapsed = System.currentTimeMillis() - this.start;
        if (log.isDebugEnabled()) {
            log.debug("execution time: " + this.elapsed + "ms");
        }
        return new DbCallResult(this.query, this.callableStatement);
    }

    public int executeUpdate() {
        return this.executeUpdate(this.autoClose);
    }

    protected int executeUpdate(boolean closeQuery) {
        int result;
        this.start = System.currentTimeMillis();
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("Executing update: " + this.getQueryString());
        }
        try {
            result = this.preparedStatement == null ? (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? this.statement.executeUpdate(this.query.sql, 1) : this.statement.executeUpdate(this.query.sql, this.generatedColumns)) : this.statement.executeUpdate(this.query.sql)) : this.preparedStatement.executeUpdate();
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Query execution failed", sex);
        }
        if (closeQuery) {
            this.close();
        }
        this.elapsed = System.currentTimeMillis() - this.start;
        if (log.isDebugEnabled()) {
            log.debug("execution time: " + this.elapsed + "ms");
        }
        return result;
    }

    public long executeCount() {
        return this.executeCount(this.autoClose);
    }

    protected long executeCount(boolean close) {
        long l;
        this.start = System.currentTimeMillis();
        this.init();
        ResultSet rs = null;
        if (log.isDebugEnabled()) {
            log.debug("Executing prepared count: " + this.getQueryString());
        }
        try {
            rs = this.preparedStatement == null ? this.statement.executeQuery(this.query.sql) : this.preparedStatement.executeQuery();
            long firstLong = DbUtil.getFirstLong(rs);
            this.elapsed = System.currentTimeMillis() - this.start;
            if (log.isDebugEnabled()) {
                log.debug("execution time: " + this.elapsed + "ms");
            }
            l = firstLong;
        }
        catch (SQLException sex) {
            try {
                throw new DbSqlException(this, "Count query failed", sex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                if (close) {
                    this.close();
                }
                throw throwable;
            }
        }
        DbUtil.close(rs);
        if (close) {
            this.close();
        }
        return l;
    }

    public <T> List<T> list(QueryMapper<T> queryMapper) {
        ResultSet resultSet = this.execute();
        ArrayList<T> list = new ArrayList<T>();
        try {
            while (resultSet.next()) {
                T t = queryMapper.process(resultSet);
                if (t == null) {
                    break;
                }
                list.add(t);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(sex);
        }
        finally {
            DbUtil.close(resultSet);
        }
        return list;
    }

    public <T> T find(QueryMapper<T> queryMapper) {
        ResultSet resultSet = this.execute();
        try {
            if (resultSet.next()) {
                T t = queryMapper.process(resultSet);
                return t;
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(sex);
        }
        finally {
            DbUtil.close(resultSet);
        }
        return null;
    }

    public <T> Set<T> listSet(QueryMapper<T> queryMapper) {
        ResultSet resultSet = this.execute();
        HashSet<T> set = new HashSet<T>();
        try {
            while (resultSet.next()) {
                T t = queryMapper.process(resultSet);
                if (t == null) {
                    break;
                }
                set.add(t);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(sex);
        }
        finally {
            DbUtil.close(resultSet);
        }
        return set;
    }

    public ResultSet getGeneratedColumns() {
        ResultSet rs;
        this.checkInitialized();
        if (this.generatedColumns == null) {
            throw new DbSqlException(this, "No column is specified as auto-generated");
        }
        try {
            rs = this.statement.getGeneratedKeys();
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "No generated keys", sex);
        }
        this.saveResultSet(rs);
        ++totalOpenResultSetCount;
        return rs;
    }

    public long getGeneratedKey() {
        this.checkInitialized();
        ResultSet rs = this.getGeneratedColumns();
        try {
            long l = DbUtil.getFirstLong(rs);
            return l;
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "No generated key as long", sex);
        }
        finally {
            DbUtil.close(rs);
            this.resultSets.remove(rs);
            --totalOpenResultSetCount;
        }
    }

    public Object getGeneratedKeyObject() {
        this.checkInitialized();
        ResultSet rs = this.getGeneratedColumns();
        try {
            Object object = DbUtil.getFirstObject(rs);
            return object;
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "No generated key as long", sex);
        }
        finally {
            DbUtil.close(rs);
            this.resultSets.remove(rs);
            --totalOpenResultSetCount;
        }
    }

    public String getQueryString() {
        if (this.debug) {
            if (this.callableStatement != null) {
                return LogabbleStatementFactory.callable().getQueryString(this.callableStatement);
            }
            if (this.preparedStatement != null) {
                return LogabbleStatementFactory.prepared().getQueryString(this.preparedStatement);
            }
        }
        if (this.query != null) {
            return this.query.sql;
        }
        return this.sqlString;
    }

    public String toString() {
        return this.getQueryString();
    }

    public static int getTotalOpenResultSetCount() {
        return totalOpenResultSetCount;
    }

    public int getOpenResultSetCount() {
        return this.resultSets == null ? 0 : this.resultSets.size();
    }

    public static enum State {
        CREATED,
        INITIALIZED,
        CLOSED;

    }
}

