/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.util.HashMap;
import java.util.Map;
import jodd.buffer.FastCharBuffer;
import jodd.inex.InExRules;
import jodd.json.JsonContext;
import jodd.json.Path;
import jodd.json.PathQuery;
import jodd.json.PrettyJsonSerializer;
import jodd.json.TypeJsonSerializer;
import jodd.json.TypeJsonSerializerMap;
import jodd.util.ArraysUtil;

public class JsonSerializer {
    protected Map<Path, TypeJsonSerializer> pathSerializersMap;
    protected TypeJsonSerializerMap typeSerializersMap;
    protected InExRules<Path, PathQuery, PathQuery> rules = new InExRules<Path, PathQuery, PathQuery>(){

        @Override
        public boolean accept(Path value, PathQuery rule, boolean include) {
            return rule.matches(value);
        }
    };
    protected String classMetadataName = Defaults.classMetadataName;
    protected boolean strictStringEncoding = Defaults.strictStringEncoding;
    protected boolean deep = Defaults.deepSerialization;
    protected Class[] excludedTypes = Defaults.excludedTypes;
    protected String[] excludedTypeNames = Defaults.excludedTypeNames;
    protected boolean excludeNulls = false;

    public static JsonSerializer create() {
        return new JsonSerializer();
    }

    public static PrettyJsonSerializer createPrettyOne() {
        return new PrettyJsonSerializer();
    }

    public JsonSerializer withSerializer(String pathString, TypeJsonSerializer typeJsonSerializer) {
        if (this.pathSerializersMap == null) {
            this.pathSerializersMap = new HashMap<Path, TypeJsonSerializer>();
        }
        this.pathSerializersMap.put(Path.parse(pathString), typeJsonSerializer);
        return this;
    }

    public JsonSerializer withSerializer(Class type, TypeJsonSerializer typeJsonSerializer) {
        if (this.typeSerializersMap == null) {
            this.typeSerializersMap = new TypeJsonSerializerMap(TypeJsonSerializerMap.get());
        }
        this.typeSerializersMap.register(type, typeJsonSerializer);
        return this;
    }

    public JsonSerializer include(String include) {
        this.rules.include(new PathQuery(include, true));
        return this;
    }

    public JsonSerializer include(String ... includes) {
        for (String include : includes) {
            this.include(include);
        }
        return this;
    }

    public JsonSerializer exclude(String exclude) {
        this.rules.exclude(new PathQuery(exclude, false));
        return this;
    }

    public JsonSerializer exclude(String ... excludes) {
        for (String exclude : excludes) {
            this.exclude(exclude);
        }
        return this;
    }

    public JsonSerializer exclude(boolean includeParent, String ... excludes) {
        for (String exclude : excludes) {
            int dotIndex;
            if (includeParent && (dotIndex = exclude.lastIndexOf(46)) != -1) {
                PathQuery pathQuery = new PathQuery(exclude.substring(0, dotIndex), true);
                this.rules.include(pathQuery);
            }
            PathQuery pathQuery = new PathQuery(exclude, false);
            this.rules.exclude(pathQuery);
        }
        return this;
    }

    public JsonSerializer setClassMetadataName(String name) {
        this.classMetadataName = name;
        return this;
    }

    public JsonSerializer withClassMetadata(boolean useMetadata) {
        this.classMetadataName = useMetadata ? "__class" : null;
        return this;
    }

    public JsonSerializer deep(boolean includeCollections) {
        this.deep = includeCollections;
        return this;
    }

    public JsonSerializer excludeTypes(String ... typeNames) {
        this.excludedTypeNames = this.excludedTypeNames == null ? typeNames : ArraysUtil.join(this.excludedTypeNames, typeNames);
        return this;
    }

    public JsonSerializer excludeTypes(Class ... types) {
        this.excludedTypes = this.excludedTypes == null ? types : ArraysUtil.join(this.excludedTypes, types);
        return this;
    }

    public JsonSerializer excludeNulls(boolean excludeNulls) {
        this.excludeNulls = excludeNulls;
        return this;
    }

    public JsonSerializer strictStringEncoding(boolean strictStringEncoding) {
        this.strictStringEncoding = strictStringEncoding;
        return this;
    }

    public void serialize(Object source, Appendable target) {
        JsonContext jsonContext = this.createJsonContext(target);
        jsonContext.serialize(source);
    }

    public String serialize(Object source) {
        FastCharBuffer fastCharBuffer = new FastCharBuffer();
        this.serialize(source, fastCharBuffer);
        return fastCharBuffer.toString();
    }

    public CharSequence serializeToCharSequence(Object source) {
        FastCharBuffer fastCharBuffer = new FastCharBuffer();
        this.serialize(source, fastCharBuffer);
        return fastCharBuffer;
    }

    public JsonContext createJsonContext(Appendable appendable) {
        return new JsonContext(this, appendable, this.excludeNulls, this.strictStringEncoding);
    }

    public static class Defaults {
        public static final String DEFAULT_CLASS_METADATA_NAME = "__class";
        public static boolean deepSerialization = false;
        public static Class[] excludedTypes = null;
        public static String[] excludedTypeNames = null;
        public static boolean strictStringEncoding = false;
        public static String classMetadataName = null;
    }
}

